package app.pivo.android.plussdk.controller.model

/**
 * MultiMovement
 *
 * Created by SusieHan on 2023/11/22
 *
 * This class is for getting the Multi direction movement information from Native controller
 */
class MultiMovement(val hSpeed: Float,
                    val hDirection: Int,
                    val hRotationDegree: Int,
                    val vSpeed: Float,
                    val vDirection: Int,
                    val vRotationDegree: Int,) {

    fun mapToMultiMovement(isFrontCamera: Boolean): MultiMovingDirection {
        return when (hDirection) {
            NativeMovement_LEFT -> {
                when (vDirection) {
                    NativeMovement_UP -> if (isFrontCamera) MultiMovingDirection.LEFT_DOWN else MultiMovingDirection.LEFT_UP
                    NativeMovement_DOWN -> if (isFrontCamera) MultiMovingDirection.LEFT_UP else MultiMovingDirection.LEFT_DOWN
                    else -> {
                        MultiMovingDirection.LEFT_UP
                    }
                }
            }

            NativeMovement_RIGHT -> {
                when (vDirection) {
                    NativeMovement_UP -> if (isFrontCamera) MultiMovingDirection.RIGHT_DOWN else MultiMovingDirection.RIGHT_UP
                    NativeMovement_DOWN -> if (isFrontCamera) MultiMovingDirection.RIGHT_UP else MultiMovingDirection.RIGHT_DOWN
                    else -> {
                        MultiMovingDirection.RIGHT_UP
                    }
                }
            }

            else -> MultiMovingDirection.LEFT_UP
        }
    }

    companion object {
        // this value is from JNI header file.
        // Please check these values from getValueOfDirection function in Native code.
        // Also there is enunm type for direction. Please check track_control.h
        const val NativeMovement_LEFT = -1
        const val NativeMovement_RIGHT = 1
        const val NativeMovement_UP = 2
        const val NativeMovement_DOWN = -2
        const val NativeMovement_NEUTRAL = 0
    }
}
