package app.pivo.android.podsdk.util

import kotlin.experimental.and
import kotlin.math.pow

/**
 * Created by murodjon on 2021/05/21
 */
internal object HexUtil {

    /**
     * Convert int to byte array
     */
    fun convertIntToByteArray(value: Int): ByteArray {
        return byteArrayOf(
            (value ushr 24).toByte(),
            (value ushr 16).toByte(),
            (value ushr 8).toByte(),
            value.toByte()
        )
    }

    // packing an array of 4 bytes to an int, big endian, minimal parentheses
    // operator precedence: <<, &, |
    // when operators of equal precedence (here bitwise OR) appear in the same expression, they are evaluated from left to right
    // int a = fromByteArray(new byte[]{0x00, (byte)0x80});
    fun convertByteArrayToInt(left: Byte, right: Byte): Int {
        return ((left and 0xFF.toByte()).toInt() shl 8) or (right and 0xFF.toByte()).toInt()
    }

    /**
     * Convert byte array to int
     */
    fun convertByteArrayToInt(bytes: ByteArray): Int {
        return (bytes[0].toInt() shl 24 or (bytes[1].toInt() shl 24 ushr 8) or (bytes[2].toInt() shl 24 ushr 16) or (bytes[3].toInt() shl 24 ushr 24)) as Int

//        return abs(((bytes[0]).toInt() shl 24) or
//                ((bytes[1] ).toInt() shl 16) or
//                ((bytes[2]).toInt() shl 8) or
//                ((bytes[3]).toInt() shl 0))
    }

    fun convertHexToSerialNumber(data: ByteArray): String {
        val stringBuilder = StringBuilder(data.size)
        data.forEachIndexed { i, v -> stringBuilder.append(if (i == 3) v.toInt() else v.toChar()) }
        return stringBuilder.toString()
    }

    fun convertHexToText(data: ByteArray): String {
        val stringBuilder = StringBuilder(data.size)
        data.forEachIndexed { i, v -> stringBuilder.append(v.toChar()) }
        return stringBuilder.toString()
    }

    fun convertHexToString(data: ByteArray): String {
        val stringBuilder = StringBuilder(data.size)
        for (byteChar in data) stringBuilder.append(String.format("%02X ", byteChar))
        return stringBuilder.toString()
    }

    /* s must be an even-length string. */
    fun hexStringToByteArray(s: String): ByteArray {
        val len = s.length
        val data = ByteArray(len / 2)
        var i = 0
        while (i < len) {
            data[i / 2] = ((Character.digit(s[i], 16) shl 4)
                    + Character.digit(s[i + 1], 16)).toByte()
            i += 2
        }
        return data
    }

    fun convertIntTo4BytesHex(num: Int): String {
        return "%04x".format(num).uppercase()
    }

    fun convertIntTo2BytesHex(num: Int): String {
        return "%02x".format(num).uppercase()
    }

    fun convertVerticalDegreeToHexByte(degree: Int): Byte? {
        return if (degree in 0..60) {
            degree.toByte()
        } else null
    }

    fun convertSpeedToHexBytes(speed: Int): ByteArray? {
        if (speed in 0..65535) {
            return hexStringToByteArray(convertIntTo4BytesHex(speed))
        }
        return null
    }

    fun convertHorizontalDegreeToHexByte(degree: Int): ByteArray? {
        if (degree in 0..65535) {
            return hexStringToByteArray(convertIntTo4BytesHex(degree))
        }
        return null
    }

    fun convertHexBytesToInt(bytes: ByteArray): Int {
        var sum = 0
        for (i in bytes.size - 1 downTo 0) {
            val x = String.format("%02X", bytes[i]).toInt(16)
            val y = 256.0.pow((bytes.size - 1 - i).toDouble()).toInt()
            sum += y * x
        }
        return sum
    }
}