package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.ButtonType
import app.pivo.android.podsdk.model.RemoteConButton
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/09/06
 */
class RemoteControllerReply(private val bytes: ByteArray) : Reply<RemoteConButton> {
    override fun getData(): RemoteConButton? {
        var remoteConButton: RemoteConButton? = null
        if (isRemoteConPressedReply(bytes)) {
            when {
                bytes[5] == 0x0A.toByte() -> {
                    remoteConButton = RemoteConButton.Mode(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x01.toByte() -> {
                    remoteConButton = RemoteConButton.OK(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x00.toByte() -> {
                    remoteConButton = RemoteConButton.Pause(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x53.toByte() -> {
                    remoteConButton = RemoteConButton.LeftContinuous(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x51.toByte() -> {
                    remoteConButton = RemoteConButton.RightContinuous(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x56.toByte() -> {
                    remoteConButton = RemoteConButton.Left(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0x54.toByte() -> {
                    remoteConButton = RemoteConButton.Right(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0xFF.toByte() -> {
                    remoteConButton = RemoteConButton.OFF
                }
                else -> {
                    getSpeed(bytes[5])?.let {
                        remoteConButton = RemoteConButton.SpeedChange(
                            bytes[3] == 0x00.toByte(),
                            if (bytes[4] == 0x01.toByte()) ButtonType.UP else ButtonType.BOTTOM,
                            it
                        )
                    }
                }
            }
        }
        return remoteConButton
    }

    companion object {
        fun isRemoteConPressedReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x05.toByte() && (
                    isMode(bytes[5]) ||
                            isOK(bytes[5]) ||
                            isPanLeft(bytes[5]) ||
                            isPanRight(bytes[5]) ||
                            isPause(bytes[4]) ||
                            isTiltUp(bytes[4]) ||
                            isTiltDown(bytes[4]) ||
                            isSpeedUp(bytes[4]) ||
                            isSpeedDown(bytes[4]))

        fun getSpeed(byte: Byte): Int? {
            return when (byte) {
                0x11.toByte() -> 10
                0x12.toByte() -> 20
                0x13.toByte() -> 30
                0x14.toByte() -> 50
                0x15.toByte() -> 60
                0x16.toByte() -> 120
                0x17.toByte() -> 300
                0x18.toByte() -> 600
                0x19.toByte() -> 1200
                0x1A.toByte() -> 1800
                0x1B.toByte() -> 3600
                0x1C.toByte() -> 7200
                0x1D.toByte() -> 10800
                0x1E.toByte() -> 21600
                0x1F.toByte() -> 43200
                else -> null
            }
        }

        private fun isOK(byte: Byte) = byte == 0x10.toByte()
        private fun isPanLeft(byte: Byte) = byte == 0x11.toByte()
        private fun isPanRight(byte: Byte) = byte == 0x12.toByte()
        private fun isTiltUp(byte: Byte) = byte == 0x13.toByte()
        private fun isTiltDown(byte: Byte) = byte == 0x14.toByte()
        private fun isSpeedDown(byte: Byte) = byte == 0x15.toByte()
        private fun isSpeedUp(byte: Byte) = byte == 0x16.toByte()
        private fun isPause(byte: Byte) = byte == 0x17.toByte()
        private fun isMode(byte: Byte) = byte == 0x0A.toByte()
    }
}