package app.pivo.android.podsdk.ota

import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2022/01/07
 *
 * This class provides chunk bytes of a firmware file
 */
object FirmwareChunkProvider {

    const val CHUNK_BYTES_SIZE = 200

    /**
     * Starts sending firmware file chunk bytes from beginning
     */
    fun getInitialFirmwareChunkBytes(firmwareBytes: ByteArray, packetSize:Int): ByteArray {
        return getFirmwareFileChunkBytes(firmwareBytes, 0, packetSize)
    }

    /**
     * Get remaining firmware file chunks
     *
     * @param bytes firmware file chuncks
     */
    fun getFirmwareFileChunkBytes(firmwareBytes: ByteArray, offsetBytes: ByteArray,packetSize:Int): ByteArray {
        //sample: 0x55 0xAB 0x10 0x00
        val offset = HexUtil.convertByteArrayToInt(offsetBytes)
        return getFirmwareFileChunkBytes(firmwareBytes, offset, packetSize)
    }

    private fun getFirmwareFileChunkBytes(firmwareBytes: ByteArray, currentOffset: Int, packetSize:Int): ByteArray {
        val currentSentBytes: ArrayList<Byte> = ArrayList()
        currentSentBytes.add(0x55.toByte())
        currentSentBytes.add(0x8A.toByte())
        currentSentBytes.add(0x01.toByte())

        // add file size 4 bytes, 00 00 00 01
        val fileSizeBytes: ByteArray = HexUtil.convertIntToByteArray(firmwareBytes.size)
        currentSentBytes.addAll(fileSizeBytes.toList())
        var deltaOffset = firmwareBytes.size - currentOffset
        if (deltaOffset >= packetSize) {
            deltaOffset = packetSize
        }

        val offsetBytes: ByteArray = HexUtil.convertIntToByteArray(currentOffset)

        // add offset size 4 bytes,
        currentSentBytes.addAll(offsetBytes.toList())

        val lengthBytes: ByteArray = HexUtil.convertIntToByteArray(deltaOffset)

        // add firmware chuck bytes size
        currentSentBytes.add(lengthBytes[3])

        for (i in 0 until deltaOffset) {
            currentSentBytes.add(firmwareBytes[currentOffset + i])
        }

        val bytes = ByteArray(currentSentBytes.size)
        for (i in bytes.indices) {
            bytes[i] = currentSentBytes[i]
        }
        return bytes
    }
}