package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.Sound
import app.pivo.android.podsdk.model.SoundType
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/05/27
 */
internal class SoundReply constructor(private val bytes: ByteArray) :
    Reply<Sound> {

    override fun getData() = when (bytes[3]) {
        0xB0.toByte() -> Sound(SoundType.ON)
        0xB1.toByte() -> Sound(SoundType.OFF)
        0xB2.toByte() -> Sound(SoundType.SUCCESS)
        0xB3.toByte() -> Sound(SoundType.DISCONNECTED)
        else -> null
    }

    companion object {
        fun isSoundReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x08.toByte()
    }
}