package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.model.HorizontalPosition
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/28
 */
internal class GetHorizontalPositionReply(private val bytes: ByteArray) :
    Reply<HorizontalPosition> {
    override fun getData(): HorizontalPosition? {
        return if (isGetHorizontalPositionReply(bytes)) {
            val degree = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
            HorizontalPosition(degree)
        } else
            null
    }

    companion object {
        fun isGetHorizontalPositionReply(bytes: ByteArray) = bytes.size == 8 &&
                bytes[3] == 0x4D.toByte() &&
                bytes[4] == 0x22.toByte()
    }
}