package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.LEDColor
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.CurrentLED

/**
 * Created by murodjon on 2021/05/28
 */
class GetLEDReply(private val bytes: ByteArray) : Reply<CurrentLED> {
    override fun getData(): CurrentLED {
        val leds = getLED(bytes)
        return CurrentLED(colors = leds, brightnessLevel = bytes[18].toInt())
    }

    private fun getLED(bytes: ByteArray): List<LEDColor> {
        val leds = arrayListOf<LEDColor>()
        if (bytes.size >= 18) {
            for (led in 6..17) {
                LEDColor.of(bytes[led])?.let { leds.add(it) }
            }
        }
        return if (leds.size == 12) leds else emptyList()
    }

    companion object {
        fun isLEDReply(bytes: ByteArray) =
            bytes.size >= 19 && bytes[4] == 0x41.toByte()
                    && bytes[3] == 0x4C.toByte()
    }
}