package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.HorizontalDirection
import app.pivo.android.podsdk.model.HorizontalMovement
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.Speed
import app.pivo.android.podsdk.model.SpeedUnit
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/28
 */
class HorizontalMovementReply(private val bytes: ByteArray) : Reply<HorizontalMovement> {
    override fun getData(): HorizontalMovement? {
        return if (isHorizontalMovementReply(bytes)) {
            getHorizontalMovement()
        } else
            null
    }

    private fun getHorizontalMovement(): HorizontalMovement {
        val speed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
        val rotationDegree = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[8], bytes[9]))

        return when (bytes[4]) {
            0x20.toByte() -> HorizontalMovement(
                HorizontalDirection.RIGHT,
                Speed(speed),
                rotationDegree = rotationDegree
            )
            0x21.toByte() -> HorizontalMovement(
                HorizontalDirection.LEFT,
                Speed(speed),
                rotationDegree = rotationDegree
            )
            0x60.toByte() -> HorizontalMovement(
                HorizontalDirection.RIGHT,
                Speed(speed, SpeedUnit.DEGREE_PER_SEC),
                rotationDegree = rotationDegree
            )
            else -> HorizontalMovement(
                HorizontalDirection.LEFT,
                Speed(speed, SpeedUnit.DEGREE_PER_SEC),
                rotationDegree = rotationDegree
            )
        }
    }

    companion object {
        fun isHorizontalMovementReply(bytes: ByteArray) = bytes.size == 10 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x20.toByte() || bytes[4] == 0x21.toByte() ||
                        bytes[4] == 0x60.toByte() || bytes[4] == 0x61.toByte())
    }
}