package app.pivo.android.podsdk.util

import app.pivo.android.podsdk.model.DeviceInfo

/**
 * Created by murodjon on 2021/08/18
 */
object PodSpeedUtil {

    fun getRemoteSupportedSpeedsSecondsPerRound(deviceInfo: DeviceInfo): IntArray {
        return when {
            deviceInfo.getPivoCategory().version == 0 -> intArrayOf(
                10,
                20,
                30,
                50,
                60,
                120,
                300,
                600,
                1200,
                1800,
                3600
            )
            deviceInfo.getPivoCategory().version > 0 -> intArrayOf(
                10,
                20,
                30,
                50,
                60,
                120,
                300,
                600,
                1200,
                1800,
                3600,
                7200,
                10800,
                21600,
                43200,
                64800,
                86400
            )
            else -> intArrayOf(0)
        }
    }

    fun getHorizontalSupportedSpeedsInSecondsPerRound(deviceInfo: DeviceInfo): IntArray {
        return when {
            deviceInfo.getPivoCategory().version == 0 -> {
                intArrayOf(10, 20, 30, 50, 60, 120, 300, 600, 1200, 1800, 3600)
            }
            deviceInfo.getPivoCategory().version > 0 -> {
                val internalUse = true
                val delta = if (internalUse) 2 else 0
                val supportedSpeed =
                    IntArray(255 - 5 + 1 +  /*remote supported speeds(start from 600 spr and 86400 spr)*/+10 + delta)
                var count = 0

                for (i in 5 - delta..255) {
                    supportedSpeed[count] = i * 2
                    count++
                }
                supportedSpeed[count] = 600
                supportedSpeed[count + 1] = 1200
                supportedSpeed[count + 2] = 1800
                supportedSpeed[count + 3] = 3600
                supportedSpeed[count + 4] = 7200
                supportedSpeed[count + 5] = 10800
                supportedSpeed[count + 6] = 21600
                supportedSpeed[count + 7] = 43200
                supportedSpeed[count + 8] = 64800
                supportedSpeed[count + 9] = 86400
                supportedSpeed
            }
            else -> {
                intArrayOf(0)
            }
        }
    }
}