package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.*

/**
 * Created by murodjon on 2021/05/27
 */
internal class DeviceInfoReply constructor(private val bytes: ByteArray) :
    Reply<PivoEvent.DeviceInfoEvent> {

    override fun getData(): PivoEvent.DeviceInfoEvent {
        val model = getModel(bytes[3])
        return PivoEvent.DeviceInfoEvent(
            DeviceInfo(
                PivoDeviceCategory.PivoPod(
                    version = bytes[5].toInt(),
                    model = model
                )
            )
        )
    }

    private fun getModel(byte: Byte): PodModel {
        return when (byte) {
            0x00.toByte(), 0x01.toByte(), 0x03.toByte(), 0x10.toByte() -> PodModel.RED
            0x02.toByte(), 0x20.toByte() -> PodModel.SILVER
            0x04.toByte(), 0x30.toByte() -> PodModel.BLACK
            0x40.toByte() -> PodModel.GOLD
            0x50.toByte() -> PodModel.LITE
            else -> PodModel.UNDEFINED
        }
    }

    companion object {
        fun isDeviceInfoReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x03.toByte() && bytes[4] == 0x01.toByte()
    }
}