package app.pivo.android.podsdk.controller.pivo

import app.pivo.android.podsdk.model.*
import app.pivo.android.podsdk.model.callback.OnPodListener

/**
 * Created by murodjon on 2021/05/20
 */
internal interface ConnectionRequester {
    /**
     * Scans for a pod devices
     */
    fun scan()

    /**
     * This function is used to connect to the device.
     * @param device is the PodDevice, you want to connect to
     */
    fun connectTo(device: PivoDevice)

    /**
     * Call this function to stop scanning
     */
    fun stopScan()

    /**
     * Call this function to disconnect
     */
    fun disconnect()

    /**
     * This function is used to check if the device is connected to headset
     */
    fun isConnected(): Boolean
}

internal interface DeviceInfoRequester {

    /**
     * This function is used to change PodX name
     * @param name is desired
     */
    fun changeName(name: String)

    /**
     * Gets device info
     */
    fun getDeviceInfo(): DeviceInfo?

    /**
     * Requests device info
     */
    fun requestDeviceInfo()

    /**
     * Requests battery level
     */
    fun requestBatteryLevel()

    /**
     * Requests mac address of a device
     */
    fun requestMacAddress()

    /**
     * Requests a serial number of device
     */
    fun requestSerialNumber()

    /**
     * Sets timeout for connection
     * @param time is timeout for pod connection
     */
    fun setConnectionTimeout(time: Int)
}

internal interface HorizontalMovementRequester {

    /**
     * Holds turning horizontally
     */
    fun holdTurningHorizontally()

    /**
     * This function is used rotating device horizontally
     */
    fun moveHorizontally(direction: HorizontalDirection, speed: Speed, degree: Int)

    /**
     * This function is used to set horizontal motor speed
     */
    fun setHorizontalMotorSpeed(speed: Speed)

    /**
     * Gets supported speeds of horizontal direction
     * @return supported speeds in seconds per round
     */
    fun getHorizontalSupportedSpeedsInSecondsPerRound(): IntArray
}

internal interface VerticalMovementRequester {
    /**
     * This function is used rotating device vertically
     */
    fun moveVertically(direction: VerticalDirection, speed: Speed, degree: Int)

    /**
     * This function is used to set vertical motor speed
     */
    fun setVerticalMotorSpeed(speed: Speed)
}

internal interface VerticalPositionRequester {
    /**
     * Gets vertical position of device
     */
    fun getVerticalPosition()

    /**
     * This function is used to move device to specific vertical position
     */
    fun moveToSpecificVerticalPosition(speed: Speed, degree: Int)

}

internal interface HorizontalPositionRequester {
    /**
     * This function is used to get horizontal position of device
     */
    fun getHorizontalPosition()

    /**
     * This function is used to move device to specific position
     */
    fun moveToSpecificHorizontalPosition(speed: Speed, degree: Int)

    /**
     * Resets position to origin
     */
    fun resetPositionHorizontally()
}

internal interface RemoteControllerRequester {
    /**
     * Turns on or off remote controller
     * @param on is used to set on and off for remote controller
     */
    fun enableRemoteController(on: Boolean)

    /**
     * Starts or initiates pairing mode
     */
    fun startPairing()

    /**
     * Cancels pairing mode
     */
    fun cancelPairing()
}

internal interface MixedMovementRequester {
    /**
     * Sends command to rotate vertical and horizontal motor
     */
    fun move(direction: MixedDirection, hSpeed: Speed, hDegree: Int, vSpeed: Speed, vDegree: Int)
}

internal interface StopRequester {
    /**
     * Stops pod movement
     */
    fun stop()
}

internal interface MovementNotifierRequester {
    /**
     * Enables Pod movement notification
     * @param enabled is to tell the device to turn on or off notification
     */
    fun enableMovementNotifier(enabled: Boolean)
}

internal interface LEDRequester {
    /**
     * Sets LED colors
     */
    fun setLED(led: CurrentLED)

    /**
     * Gets LED colors
     */
    fun getLEDColor()

    fun runLEDPreset(patternType: LightPatternType, level:Int)

    fun stopLEDPreset()
}

internal interface SoundRequester {
    /**
     * Makes beam sound
     * @param sound is sound type [SoundType]
     */
    fun makeBeamSound(sound: SoundType)
}

internal interface OTAUpdateRequester {
    /**
     * Upgrades a firmware of pod or remote controller
     * @param data is new firmware byte array
     */
    fun initiateOTA(data: ByteArray, otaPacketSize: Int)
}

internal interface PodAuthenticationRequester{
    /**
     * This function is only used for testing purposes!!!
     * Authenticates Pod
     * @param wrongAuth if it's true, then it authenticates with wrong code.
     */
    fun authPod(wrongAuth:Boolean)
}