package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.MacAddress
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/27
 */
class MacAddressReply(private val bytes: ByteArray) : Reply<MacAddress> {

    override fun getData() = getMacAddress()?.let { MacAddress(it) }

    private fun getMacAddress(): String? {
        return if (isMacAddressReply(bytes)) {
            val sizeOfBytes = bytes.size
            HexUtil.convertHexToString(bytes.copyOfRange(3, sizeOfBytes))
        } else null
    }

    companion object {
        fun isMacAddressReply(bytes: ByteArray) =
            bytes.size >= 9 && bytes[2] == 0x1B.toByte()
    }
}