package app.pivo.android.podsdk.model

/**
 * Created by murodjon on 2021/05/21
 */
enum class LEDColor(var value: Int) {
    OFF(0),
    CYAN(1),
    BLUE(2),
    RED(3),
    GREEN(4),
    YELLOW(5),
    PURPLE(6),
    ORANGE(7),
    WHITE(8);

    companion object {
        fun of(index: Int): LEDColor {
            return when (index) {
                0 -> OFF
                1 -> CYAN
                2 -> BLUE
                3 -> RED
                4 -> GREEN
                5 -> YELLOW
                6 -> PURPLE
                7 -> ORANGE
                8 -> WHITE
                else -> OFF
            }
        }

        fun of(byte: Byte): LEDColor? {
            return when (byte) {
                0x01.toByte() -> CYAN
                0x02.toByte() -> BLUE
                0x03.toByte() -> RED
                0x04.toByte() -> GREEN
                0x05.toByte() -> YELLOW
                0x06.toByte() -> PURPLE
                0x07.toByte() -> ORANGE
                0xFF.toByte() -> WHITE
                0x00.toByte() -> OFF
                else -> null
            }
        }

    }

    fun getValue(): Byte {
        return when (this) {
            CYAN -> 0x01.toByte()
            BLUE -> 0x02.toByte()
            RED -> 0x03.toByte()
            GREEN -> 0x04.toByte()
            YELLOW -> 0x05.toByte()
            PURPLE -> 0x06.toByte()
            ORANGE -> 0x07.toByte()
            WHITE -> 0xFF.toByte()
            else -> 0x00.toByte()
        }
    }
}
