package app.pivo.android.podsdk.cmd.parser.impl

import app.pivo.android.podsdk.model.PivoEvent
import app.pivo.android.podsdk.cmd.parser.ReplyCommandParser
import app.pivo.android.podsdk.cmd.parser.impl.podmax.RemoteControllerReply
import app.pivo.android.podsdk.cmd.parser.impl.podremote.FirmwareUpdateReply

/**
 * Created by murodjon on 2022/01/13
 */
internal class PodRemoteReplyCommandParserImpl : ReplyCommandParser {
    override fun getEvent(bytes: ByteArray): PivoEvent {
        return getType(bytes)
    }

    private fun getType(bytes: ByteArray): PivoEvent {
        return when {
            FirmwareUpdateReply.isOTAProgressReply(bytes) -> {
                PivoEvent.FirmwareUpdateEvent(FirmwareUpdateReply(bytes).getData()!!)
            }
            RemoteControllerReply.isRemoteConPressedReply(bytes) -> {
                val remoteCon = RemoteControllerReply(bytes).getData()
                if (remoteCon == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.RemoteConButtonEvent(remoteCon)
                }
            }
            else -> PivoEvent.InvalidReplyEvent(bytes)
        }
    }
}