package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.ButtonType
import app.pivo.android.podsdk.model.RemoteConButton
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/09/06
 */
class RemoteControllerReply(private val bytes: ByteArray) : Reply<RemoteConButton> {
    override fun getData(): RemoteConButton? {
        var remoteConButton: RemoteConButton? = null
        if (isRemoteConPressedReply(bytes)) {
            when {
                isMode(bytes[5]) -> {
                    remoteConButton = RemoteConButton.Mode(bytes[3] == 0x00.toByte())
                }
                isOK(bytes[5]) -> {
                    remoteConButton = RemoteConButton.OK(bytes[3] == 0x00.toByte())
                }
                isLeftContinuous(bytes[5]) -> {
                    remoteConButton = RemoteConButton.LeftContinuous(bytes[3] == 0x00.toByte())
                }
                isRightContinuous(bytes[5]) -> {
                    remoteConButton = RemoteConButton.RightContinuous(bytes[3] == 0x00.toByte())
                }
                isPanLeft(bytes[5]) -> {
                    remoteConButton = RemoteConButton.Left(bytes[3] == 0x00.toByte())
                }
                isPanRight(bytes[5]) -> {
                    remoteConButton = RemoteConButton.Right(bytes[3] == 0x00.toByte())
                }
                bytes[5] == 0xFF.toByte() -> {
                    remoteConButton = RemoteConButton.OFF
                }
                getSpeed(bytes[5])!=null->{
                    remoteConButton = RemoteConButton.SpeedChange(
                        bytes[3] == 0x00.toByte(),
                        if (bytes[4] == 0x01.toByte()) ButtonType.UP else ButtonType.BOTTOM,
                        getSpeed(bytes[5])!!
                    )
                }
                isPause(bytes[5]) -> {
                    remoteConButton = RemoteConButton.Pause(bytes[3] == 0x00.toByte())
                }
            }
        }
        return remoteConButton
    }

    companion object {
        fun isRemoteConPressedReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x05.toByte() && (
                    isLeftContinuous(bytes[5]) ||
                            isRightContinuous(bytes[5]) ||
                            isMode(bytes[5]) ||
                            isOK(bytes[5]) ||
                            isPanLeft(bytes[5]) ||
                            isPanRight(bytes[5]) ||
                            isPause(bytes[5]) ||
                            isTiltUp(bytes[4]) ||
                            isTiltDown(bytes[4]) ||
                            getSpeed(bytes[5]) != null)

        fun getSpeed(byte: Byte): Int? {
            return when (byte) {
                0x11.toByte() -> 10
                0x12.toByte() -> 20
                0x13.toByte() -> 30
                0x14.toByte() -> 50
                0x15.toByte() -> 60
                0x16.toByte() -> 120
                0x17.toByte() -> 300
                0x18.toByte() -> 600
                0x19.toByte() -> 1200
                0x1A.toByte() -> 1800
                0x1B.toByte() -> 3600
                0x1C.toByte() -> 7200
                0x1D.toByte() -> 10800
                0x1E.toByte() -> 21600
                0x1F.toByte() -> 43200
                else -> null
            }
        }

        private fun isMode(byte: Byte) = byte == 0x0A.toByte()
        private fun isOK(byte: Byte) = byte == 0x01.toByte()
        private fun isPause(byte: Byte) = byte == 0x00.toByte()
        private fun isLeftContinuous(byte: Byte) =
            isLeftContinuousV0(byte) || isLeftContinuousAboveV0(byte)

        private fun isRightContinuous(byte: Byte) =
            isRightContinuousV0(byte) || isRightContinuousAboveV0(byte)

        private fun isPanLeft(byte: Byte) = isPanLeftV0(byte) || isPanLeftAboveV0(byte)
        private fun isPanRight(byte: Byte) = isPanRightV0(byte) || isPanRightAboveV0(byte)

        private fun isTiltUp(byte: Byte) = byte == 0x13.toByte()
        private fun isTiltDown(byte: Byte) = byte == 0x14.toByte()
        private fun isSpeedDown(byte: Byte) = byte == 0x15.toByte()
        private fun isSpeedUp(byte: Byte) = byte == 0x16.toByte()

        private fun isLeftContinuousV0(byte: Byte) = byte == 0x53.toByte()
        private fun isRightContinuousV0(byte: Byte) = byte == 0x51.toByte()

        private fun isLeftContinuousAboveV0(byte: Byte) = byte == 0x23.toByte()
        private fun isRightContinuousAboveV0(byte: Byte) = byte == 0x21.toByte()

        private fun isPanLeftV0(byte: Byte) = byte == 0x26.toByte()
        private fun isPanRightV0(byte: Byte) = byte == 0x24.toByte()

        private fun isPanLeftAboveV0(byte: Byte) = byte == 0x56.toByte()
        private fun isPanRightAboveV0(byte: Byte) = byte == 0x54.toByte()
    }
}