package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.Pairing
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.PairingStatus

/**
 * Created by murodjon on 2021/05/27
 */
internal class PairingReply constructor(private val bytes: ByteArray) :
    Reply<Pairing> {

    override fun getData(): Pairing {
        var pairingStatus = PairingStatus.CANCELLED
        when (bytes[2]) {
            0x51.toByte() -> pairingStatus = PairingStatus.STARTED
            0x52.toByte() -> pairingStatus = PairingStatus.CANCELLED
            0x53.toByte() -> pairingStatus = when (bytes[5]) {
                0x00.toByte() -> PairingStatus.FAILED
                else -> PairingStatus.SUCCEED
            }
            0x54.toByte() -> pairingStatus = when (bytes[5]) {
                0x01.toByte() -> PairingStatus.POWER_PRESSED_3_TIMES
                else -> PairingStatus.POWER_PRESSED_IN_PAIRING
            }
            0x55.toByte() -> pairingStatus = when (bytes[5]) {
                0x01.toByte() -> PairingStatus.BACK_TO_NORMAL
                else -> PairingStatus.PAIRING_SUCCESSFUL
            }
        }
        return Pairing(pairingStatus)
    }

    companion object {
        fun isPairing(bytes: ByteArray) = bytes.size >= 6 && (bytes[2] == 0x51.toByte() ||
                bytes[2] == 0x52.toByte() || bytes[2] == 0x53.toByte() || bytes[2] == 0x54.toByte() ||
                bytes[2] == 0x55.toByte())
    }
}