package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.ChangedSpeed
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/07/13
 */
class VerticalSpeedReply(private val bytes: ByteArray) : Reply<ChangedSpeed> {
    override fun getData(): ChangedSpeed? {
        return if (isVerticalSpeedReply(bytes)) {
            ChangedSpeed(false, HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7])))
        } else null
    }

    companion object {
        fun isVerticalSpeedReply(bytes: ByteArray) = bytes.size == 8 &&
                bytes[3] == 0x4D.toByte() &&
                bytes[4] == 0x34.toByte()
    }
}