package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.ota.FirmwareUpdateState

/**
 * Created by murodjon on 2022/01/04
 */
internal class FirmwareUpdateReply(private val bytes: ByteArray) : Reply<FirmwareUpdateState> {

    override fun getData(): FirmwareUpdateState? {
        return getOTAStateOrNONE(bytes)
    }

    private fun getOTAStateOrNONE(bytes: ByteArray): FirmwareUpdateState? {
        return when {
            isOTAInitiationFailed(bytes) -> FirmwareUpdateState.INITIATION_FAILED
            isOTAInitiated(bytes) -> FirmwareUpdateState.INITIATED
            isOTAProgress(bytes) -> {
                when (bytes[6]) {
                    0xAB.toByte() -> FirmwareUpdateState.FILE_CHUNKS_RECEIVED
                    0xAC.toByte() -> FirmwareUpdateState.FILE_CHUNKS_NOT_RECEIVED
                    0xAD.toByte() -> FirmwareUpdateState.OTA_FAILED
                    0xAF.toByte() -> FirmwareUpdateState.ALL_FILE_CHUNKS_RECEIVED
                    else -> null
                }
            }
            else -> {
                null
            }
        }
    }

    companion object {
        fun isOTAProgressReply(bytes: ByteArray): Boolean =
            isOTAProgress(bytes) ||
                    isOTAInitiated(bytes) ||
                    isOTAInitiate(bytes) ||
                    isOTAInitiationFailed(bytes)

        private fun isOTAProgress(bytes: ByteArray) =
            bytes.size >= 11 && bytes[3] == 0x55.toByte() && bytes[4] == 0x8A.toByte()

        private fun isOTAInitiationFailed(bytes: ByteArray): Boolean =
            isOTAInitiate(bytes) && bytes[7] == 0xFF.toByte()

        private fun isOTAInitiated(bytes: ByteArray) =
            isOTAInitiate(bytes) && bytes[7] == 0x00.toByte()

        private fun isOTAInitiate(bytes: ByteArray) = bytes.size >= 8
                && bytes[3] == 0x55.toByte()
                && bytes[4] == 0x8F.toByte()
    }
}