package app.pivo.android.podsdk.events

/**
 * Created by murodjon on 2021/01/19
 *
 * [PivoEvent] is a list of events, which are sent by Pivo Headset controller through  [PivoEventBus]
 */
sealed class PivoEvent {

    /**
     * [ConnectionComplete] event is sent if [connectTo] completes the connection to Pivo device.
     */
    class ConnectionComplete

    /**
     * ConnectionFailure event is published if Pivo disconnects from an application.
     */
    class ConnectionFailure

    /**
     * [InvalidReply] is sent by [PivoEventBus] if invalid or incomplete bytes received
     */
    class InvalidReply(private val text: String) {
        fun getOriginalReply() = text
    }
}