package app.pivo.android.podsdk.cmd.parser.factory.impl

import app.pivo.android.podsdk.model.PivoDeviceType
import app.pivo.android.podsdk.cmd.parser.ReplyCommandParser
import app.pivo.android.podsdk.cmd.parser.factory.ReplyCommandParserFactory
import app.pivo.android.podsdk.cmd.parser.impl.PodMaxReplyCommandParserImpl
import app.pivo.android.podsdk.cmd.parser.impl.PodRemoteReplyCommandParserImpl
import app.pivo.android.podsdk.cmd.parser.impl.PodReplyCommandParserImpl
import app.pivo.android.podsdk.cmd.parser.impl.PodXReplyCommandParserImpl
import app.pivo.android.podsdk.model.PivoDevice

/**
 * Created by murodjon on 2022/01/13
 */
internal class ReplyCommandParserFactoryImpl(
    private val podType: PivoDeviceType,
    private val podDevice: PivoDevice
) :
    ReplyCommandParserFactory {
    override fun getReplyCommandParser(): ReplyCommandParser {
        return when (podType) {
            PivoDeviceType.POD -> {
                PodReplyCommandParserImpl(podDevice)
            }
            PivoDeviceType.POD_X -> {
                PodXReplyCommandParserImpl(podDevice)
            }
            PivoDeviceType.POD_MAX -> {
                PodMaxReplyCommandParserImpl(podDevice)
            }
            PivoDeviceType.POD_REMOTE -> {
                PodRemoteReplyCommandParserImpl()
            }
        }
    }
}