package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.SerialNumber
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/27
 */
class SerialNumberReply(private val bytes: ByteArray) : Reply<SerialNumber> {
    override fun getData() = getSerialNumber()?.let { SerialNumber(it) }

    private fun getSerialNumber(): String? {
        return if (isValidSerialNumber()) {
            val sizeOfBytes = bytes.size
            HexUtil.convertHexToSerialNumber(bytes.copyOfRange(3, sizeOfBytes))
        } else null
    }

    private fun isValidSerialNumber() = bytes.size >= 15
            && bytes[2] == 0x1C.toByte()

    companion object {
        fun isSerialNumberReply(bytes: ByteArray) = bytes.size >= 6
                && bytes[2] == 0x1C.toByte()
    }
}