package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.DeviceInfo
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.PivoDeviceCategory

/**
 * Created by murodjon on 2021/05/27
 */
internal class DeviceInfoReply constructor(private val bytes: ByteArray) : Reply<DeviceInfo> {

    override fun getData(): DeviceInfo {
//        val model = when (bytes[6]) {
//            0xA1.toByte() -> PodModel.POD_X
//            0xA2.toByte() -> PodModel.POD_MAX
//            0xA3.toByte() -> PodModel.POD_PRO
//            else -> PodModel.OTHER
//        }
        return DeviceInfo(PivoDeviceCategory.PivoPodX(bytes[7].toInt()))
    }

    companion object {
        fun isDeviceInfoReply(bytes: ByteArray) =
            bytes.size >= 8 && bytes[3] == 0x42.toByte() && bytes[4] == 0x01.toByte()
    }
}