package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.ChangedSpeed
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.cmd.parser.impl.pod.RemoteControllerReply.Companion.getSpeed

/**
 * Created by murodjon on 2021/07/13
 */
class HorizontalSpeedReply(private val bytes: ByteArray) : Reply<ChangedSpeed> {
    override fun getData(): ChangedSpeed? {
        return if (isHorizontalSpeedReply(bytes)) {
            if (isLegacySpeed(bytes[2])) {
                ChangedSpeed(true, speed = getSpeed(bytes[3]) ?: 0)
            } else {
                ChangedSpeed(true, speed = (bytes[3].toInt()) * 2)
            }
        } else null
    }

    companion object {
        private fun isLegacySpeed(byte: Byte) = byte == 0x06.toByte()
        private fun isNewSpeed(byte: Byte) = byte == 0x10.toByte()

        fun isHorizontalSpeedReply(bytes: ByteArray) = bytes.size == 6 &&
                (bytes[2] == 0x06.toByte() || bytes[2] == 0x10.toByte())
    }
}