package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.LEDPreset
import app.pivo.android.podsdk.model.LightPatternType

/**
 * Created by murodjon on 2022/03/07
 */
class LEDRunPresetReply(private val bytes: ByteArray) : Reply<LEDPreset> {
    override fun getData(): LEDPreset? {
        return if (isLEDRunPresetReply(bytes)) {
            val patternType = getLightPatternType(bytes[6])
            patternType ?: return null
            LEDPreset(patternType, bytes[7].toInt())
        } else {
            null
        }
    }

    private fun getLightPatternType(byte: Byte): LightPatternType? {
        return when (byte) {
            0x01.toByte() -> LightPatternType.PatternA
            0x02.toByte() -> LightPatternType.PatternB
            0x03.toByte() -> LightPatternType.PatternC
            0x04.toByte() -> LightPatternType.PatternD
            0x05.toByte() -> LightPatternType.PatternE
            0x06.toByte() -> LightPatternType.PatternF
            0x07.toByte() -> LightPatternType.PatternG
            0x08.toByte() -> LightPatternType.PatternH
            else -> null
        }
    }

    companion object {
        fun isLEDRunPresetReply(bytes: ByteArray) =
            bytes.size >= 8 &&
                    bytes[3] == 0x4C.toByte() &&
                    bytes[4] == 0x21.toByte()
    }
}