package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.GoToVerticalPosition
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/07/13
 */
internal class GoToVerticalPositionReply(private val bytes: ByteArray) :
    Reply<GoToVerticalPosition> {
    override fun getData(): GoToVerticalPosition? {
        return if (isGoToVerticalReply(bytes)) {
            GoToVerticalPosition(
                speed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7])),
                degree = bytes[8].toInt()
            )
        } else null
    }

    companion object {
        fun isGoToVerticalReply(bytes: ByteArray) = bytes.size == 9 &&
                bytes[3] == 0x4D.toByte() &&
                bytes[4] == 0x33.toByte()
    }
}