package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.ConnectionTimeOut
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/05/27
 */
internal class ConnectionTimeoutReply constructor(private val bytes: ByteArray) :
    Reply<ConnectionTimeOut> {

    override fun getData(): ConnectionTimeOut {
        return ConnectionTimeOut(bytes[5].toInt() * 10)
    }

    companion object {
        fun isTimeoutReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0xA1.toByte()
    }
}