package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.model.VerticalDirection
import app.pivo.android.podsdk.model.VerticalMovement
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/28
 */
class VerticalMovementReply(private val bytes: ByteArray) : Reply<VerticalMovement> {
    override fun getData(): VerticalMovement? {
        return if (isVerticalMovementReply(bytes)) {
            getVerticalMovement()
        } else
            null
    }

    private fun getVerticalMovement(): VerticalMovement {
        val speed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
        val direction = if (isUp(bytes[4])) VerticalDirection.UP else VerticalDirection.DOWN
        val rotationDegree = bytes[8].toInt()
        return VerticalMovement(direction, speed, rotationDegree = rotationDegree)
    }

    private fun isUp(byte: Byte) = byte == 0x30.toByte()

    private fun isDown(byte: Byte) = byte == 0x31.toByte()

    companion object {
        fun isVerticalMovementReply(bytes: ByteArray) = bytes.size == 9 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x30.toByte() || bytes[4] == 0x31.toByte())
    }
}