package app.pivo.android.podsdk.model

import app.pivo.android.podsdk.BuildConfig
import java.io.Serializable

/**
 * Created by murodjon on 2021/05/20
 *  This [DeviceInfo] class holds PivoDevice [Model] and version
 */
class DeviceInfo(
    private val pivoDeviceCategory: PivoDeviceCategory
) : Serializable {

    private var serialNumber: String? = null
    private var macAddress: String = ""
    private var name: String = ""
    private var deviceInfoInHex: String = ""

    constructor(
        pivoDeviceCategory: PivoDeviceCategory,
        macAddress: String
    ) : this(pivoDeviceCategory) {
        this.macAddress = macAddress
    }

    constructor(
        pivoDeviceCategory: PivoDeviceCategory,
        macAddress: String,
        serialNumber: String
    ) : this(pivoDeviceCategory, macAddress) {
        this.serialNumber = serialNumber
        this.macAddress = macAddress
    }

    /**
     * [getType] is called to get Pod type
     */
    fun getPivoCategory() = pivoDeviceCategory

    /**
     * [getMacAddress] is called to get mac address of the connected device
     */
    fun getMacAddress() = macAddress

    /**
     * [getSerialNumber] is called to get serial number of the connected device
     */
    fun getSerialNumber() = serialNumber

    /**
     * [getName] returns the name of a device
     */
    fun getName() = name

    internal fun setSerialNumber(serialNumber: String?) {
        this.serialNumber = serialNumber
    }

    internal fun setMacAddress(macAddress: String) {
        this.macAddress = macAddress
    }

    internal fun setName(name: String) {
        this.name = name
    }

    internal fun setDeviceInfoInHex(value: String) {
        this.deviceInfoInHex = value
    }

    override fun toString(): String {
        return "DeviceInfo(" +
                "name=$name, " +
                "macAddress=$macAddress, " +
                "category= $pivoDeviceCategory " +
                "${if (serialNumber != null) ", serialNumber=$serialNumber" else ""}," +
                "${if (BuildConfig.DEBUG) "InHex=$deviceInfoInHex" else ""})"
    }
}