package app.pivo.android.podsdk.auth

import app.pivo.android.podsdk.model.PivoDeviceCategory

/**
 * Created by murodjon on 2021/08/18
 */
internal class PodAuthenticator(
    private val deviceCategory: PivoDeviceCategory
) {

    fun getAnswer(input: Int): Int {
        return getAuthAnswer(deviceCategory.version, deviceCategory.getDeviceCategory(), input)
    }

    fun verifyAuth(input: Int, answer: Int): Boolean {
        return verifyAuthCode(
            deviceCategory.version,
            deviceCategory.getDeviceCategory(),
            input,
            answer
        )
    }

    private external fun getAuthAnswer(version: Int, deviceCategory: Int, input: Int): Int
    private external fun verifyAuthCode(
        version: Int,
        deviceCategory: Int,
        input: Int,
        answer: Int
    ): Boolean

    companion object {
        init {
            System.loadLibrary("auth-lib")
        }
    }
}