package app.pivo.android.podsdk.cmd.parser.impl.pod

import app.pivo.android.podsdk.model.Name
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/27
 */
class NameChangedReply(private val bytes: ByteArray) : Reply<Name> {
    override fun getData() = getName()?.let { Name(it) }

    private fun getName(): String? {
        return if (isNameChangedReply(bytes)) {
            HexUtil.convertHexToText(bytes.copyOfRange(5, bytes.size))
        } else null
    }

    companion object {
        fun isNameChangedReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x7F.toByte()

    }
}