package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.model.ConnectionTimeOut
import app.pivo.android.podsdk.cmd.parser.impl.Reply

/**
 * Created by murodjon on 2021/05/27
 */
internal class ConnectionTimeoutReply constructor(private val bytes: ByteArray) :
    Reply<ConnectionTimeOut> {

    override fun getData(): ConnectionTimeOut {
        return ConnectionTimeOut(bytes[6].toInt()*10)
    }

    companion object {
        fun isTimeoutReply(bytes: ByteArray) =
            bytes.size >= 8 && bytes[3] == 0x42.toByte() && bytes[4] == 0x02.toByte()
    }
}