package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.model.Pairing
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.PairingStatus

/**
 * Created by murodjon on 2021/05/27
 */
internal class PairingReply constructor(private val bytes: ByteArray) :
    Reply<Pairing> {

    override fun getData(): Pairing {
        var pairingStatus = PairingStatus.CANCELLED
        when (bytes[4]) {
            0x02.toByte() -> pairingStatus =
                when (bytes[6]) {
                    0x00.toByte() -> PairingStatus.STARTED
                    0x01.toByte() -> PairingStatus.SUCCEED
                    else
                        /*if(bytes[6]==0x02.toByte())*/ -> PairingStatus.FAILED
                }
            0x03.toByte() -> pairingStatus = PairingStatus.CANCELLED
            0xFA.toByte() -> {
                pairingStatus = when (bytes[6]) {
                    0x00.toByte() -> PairingStatus.POWER_PRESSED_3_TIMES
                    0x01.toByte() -> PairingStatus.POWER_PRESSED_IN_PAIRING
                    0x02.toByte() -> PairingStatus.BACK_TO_NORMAL
                    /*0x03.toByte()*/else -> PairingStatus.PAIRING_SUCCESSFUL
                }
            }
        }
        return Pairing(pairingStatus)
    }

    companion object {
        fun isPairing(bytes: ByteArray) = bytes.size >= 8 && bytes[3] == 0x52.toByte() &&
                (bytes[4] == 0x02.toByte()
                        || bytes[4] == 0x03.toByte()
                        || bytes[4] == 0xFA.toByte())
    }
}