package app.pivo.android.podsdk.cmd.parser.impl

import app.pivo.android.podsdk.model.PivoEvent
import app.pivo.android.podsdk.cmd.parser.ReplyCommandParser
import app.pivo.android.podsdk.cmd.parser.impl.podmax.RemoteControllerReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.*
import app.pivo.android.podsdk.cmd.parser.impl.podmax.BatteryReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.ConnectionTimeoutReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.DeviceInfoReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.FirmwareUpdateReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.GetHorizontalPositionReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.GoToHorizontalPositionReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.NotifierReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.PairingReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.RemoteConEnabledReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.ResetHorizontalPositionReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.SoundReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.StopReply
import app.pivo.android.podsdk.cmd.parser.impl.podmax.AuthReply
import app.pivo.android.podsdk.model.DeviceInfo
import app.pivo.android.podsdk.model.PivoDevice

/**
 * Created by murodjon on 2022/01/13
 */
internal class PodMaxReplyCommandParserImpl(private val podDevice: PivoDevice) :
    ReplyCommandParser {
    private var deviceInfo: DeviceInfo? = null


    override fun getEvent(bytes: ByteArray): PivoEvent {
        return getType(bytes)
    }

    private fun getType(bytes: ByteArray): PivoEvent {
        return when {
            FirmwareUpdateReply.isOTAProgressReply(bytes) -> {
                PivoEvent.FirmwareUpdateEvent(FirmwareUpdateReply(bytes).getData()!!)
            }
            RemoteControllerReply.isRemoteConPressedReply(bytes) -> {
                val remoteCon = RemoteControllerReply(bytes).getData()
                if (remoteCon == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.RemoteConButtonEvent(remoteCon)
                }
            }
            // basic command set
            DeviceInfoReply.isDeviceInfoReply(bytes) -> {
                val deviceInfo = DeviceInfoReply(bytes)
                    .getData()
                this.deviceInfo = deviceInfo
                PivoEvent.DeviceInfoEvent(deviceInfo)
            }
            AuthReply.isAuthNotification(bytes) -> PivoEvent.AuthenticationEvent(AuthReply(bytes).getData())
            ConnectionTimeoutReply.isTimeoutReply(bytes) -> PivoEvent.ConnectionTimeOutEvent(
                ConnectionTimeoutReply(bytes).getData()
            )
            BatteryReply.isBatteryReply(bytes) -> PivoEvent.BatteryEvent(BatteryReply(bytes).getData())
            MacAddressReply.isMacAddressReply(bytes) -> {
                val macAddress = MacAddressReply(bytes).getData()
                if (macAddress == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.MacAddressEvent(macAddress)
                }
            }
            SerialNumberReply.isSerialNumberReply(bytes) -> {
                val serialNum =
                    deviceInfo?.let { SerialNumberReply(bytes, it.getPivoCategory()).getData() }
                if (serialNum == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.SerialNumberEvent(serialNum)
                }
            }

            // movement control command set
            StopReply.isStopReply(bytes) -> PivoEvent.Stop
            // remove controller command set
            RemoteConEnabledReply.isRemoteBypassReply(bytes) -> PivoEvent.RemoteConBypassEvent(
                RemoteConEnabledReply(bytes).getData()
            )
            PairingReply.isPairing(bytes) -> PivoEvent.RemoteConPairingEvent(PairingReply(bytes).getData())

            // Change device name
            NameChangedReply.isNameChangedReply(bytes) -> {
                val name = NameChangedReply(bytes).getData()
                if (name == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.NameChangedEvent(name)
                }
            }
            SoundReply.isSoundReply(bytes) -> {
                val sound = SoundReply(bytes).getData()
                if (sound == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.SoundEvent(sound)
                }
            }
            NotifierReply.isNotifierReply(bytes) -> PivoEvent.NotifierEvent(NotifierReply(bytes).getData())
            RemoteControllerReply.isRemoteConPressedReply(bytes) -> {
                val remoteCon = RemoteControllerReply(bytes).getData()
                if (remoteCon == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.RemoteConButtonEvent(remoteCon)
                }
            }
            HorizontalMovementReply.isHorizontalMovementReply(bytes) -> {
                val movement = HorizontalMovementReply(
                    bytes
                ).getData()
                if (movement == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.HorizontalMovementEvent(movement)
                }
            }
            HorizontalSpeedReply.isHorizontalSpeedReply(bytes) -> {
                val speed = HorizontalSpeedReply(bytes).getData()
                if (speed == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.SpeedEvent(speed)
                }
            }
            GetHorizontalPositionReply.isGetHorizontalPositionReply(bytes) -> {
                val reply = GetHorizontalPositionReply(
                    bytes
                )
                if (reply.getData() != null) {
                    PivoEvent.HorizontalPositionEvent(reply.getData()!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            GoToHorizontalPositionReply.isGoToHorizontalReply(bytes) -> {
                val event = GoToHorizontalPositionReply(
                    bytes
                ).getData()

                if (event != null) {
                    PivoEvent.GoToHorizontalPositionEvent(event!!)
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            ResetHorizontalPositionReply.isResetHorizontalReply(bytes) -> {
                val data = ResetHorizontalPositionReply(
                    bytes
                ).getData()
                if (data != null) {
                    PivoEvent.HorizontalResetToOrigin
                } else {
                    PivoEvent.InvalidReplyEvent(bytes)
                }
            }
            // LED ring control
            GetLEDReply.isLEDReply(bytes) -> {
                val led = GetLEDReply(bytes).getData()
                PivoEvent.CurrentLEDEvent(led)
            }
            SetLEDReply.isLEDSetReply(bytes) -> {
                PivoEvent.LEDSetEvent(SetLEDReply(bytes).getData())
            }
            // LED preset
            LEDStopPresetReply.isLEDStopPresetReply(bytes) -> {
                PivoEvent.LEDStopPreset
            }
            LEDRunPresetReply.isLEDRunPresetReply(bytes) -> {
                val ledRunPreset = LEDRunPresetReply(bytes).getData()
                if (ledRunPreset == null) {
                    PivoEvent.InvalidReplyEvent(bytes)
                } else {
                    PivoEvent.LEDPresetEvent(ledRunPreset.patternType, ledRunPreset.brightnessLevel)
                }
            }
            // Change device name
            else -> PivoEvent.InvalidReplyEvent(bytes)
        }
    }
}