package app.pivo.android.podsdk.cmd.parser.impl.podx

import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.*
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/28
 */
class VerticalMovementReply(private val bytes: ByteArray) : Reply<VerticalMovement> {
    override fun getData(): VerticalMovement? {
        return if (isVerticalMovementReply(bytes)) {
            getVerticalMovement()
        } else
            null
    }

    private fun getVerticalMovement(): VerticalMovement {
        val speed = HexUtil.convertHexBytesToInt(byteArrayOf(bytes[6], bytes[7]))
        val rotationDegree = bytes[8].toInt()

        return when (bytes[4]) {
            0x30.toByte() -> VerticalMovement(
                VerticalDirection.UP,
                Speed(speed),
                rotationDegree = rotationDegree
            )
            0x31.toByte() -> VerticalMovement(
                VerticalDirection.DOWN,
                Speed(speed),
                rotationDegree = rotationDegree
            )
            0x70.toByte() -> VerticalMovement(
                VerticalDirection.UP,
                Speed(speed, SpeedUnit.DEGREE_PER_SEC),
                rotationDegree = rotationDegree
            )
            else -> VerticalMovement(
                VerticalDirection.DOWN,
                Speed(speed, SpeedUnit.DEGREE_PER_SEC),
                rotationDegree = rotationDegree
            )
        }
    }

    companion object {
        fun isVerticalMovementReply(bytes: ByteArray) = bytes.size == 9 &&
                bytes[3] == 0x4D.toByte() &&
                (bytes[4] == 0x30.toByte() ||
                    bytes[4] == 0x31.toByte() ||
                    bytes[4] == 0x70.toByte() ||
                    bytes[4] == 0x71.toByte())
    }
}