package app.pivo.android.podsdk

import android.content.Context
import app.pivo.android.podsdk.controller.pivo.impl.PivoDeviceManagerImpl
import app.pivo.android.podsdk.model.*
import app.pivo.android.podsdk.model.callback.*
import kotlinx.coroutines.CoroutineScope

/**
 * Created by murodjon on 2021/05/20
 */
class PodSdk constructor(context: Context) : IPodSdk {

    private var controller = PivoDeviceManagerImpl(context)

    companion object {
        private var instance: PodSdk? = null

        fun init(context: Context) {
            instance = PodSdk(context)
        }

        fun getInstance(): PodSdk {
            return instance!!
        }
    }

    /**
     * This function[scan] is used to scan ble pod devices
     */
    override fun scan() {
        controller.scan()
    }

    /**
     * This function[cancelScan] cancels scanning ble devices
     */
    override fun cancelScan() {
        controller.stopScan()
    }

    /**
     * This function[disconnect] disconnects from ble devices
     */
    override fun disconnect() {
        controller.disconnect()
    }

    /**
     * This function [isConnected] checks connectivity of devices
     */
    override fun isConnected(): Boolean {
        return controller.isConnected()
    }

    /**
     * This function [connectTo] is used to connect to the device
     */
    override fun connectTo(device: PivoDevice) {
        controller.connectTo(device)
    }

    /**
     * This [move] function's supported on PodX
     */
    override fun move(
        direction: MixedDirection,
        verticalSpeed: Speed,
        verticalDegree: Int,
        horizontalSpeed: Speed,
        horizontalDegree: Int
    ) {
        controller.move(
            direction,
            horizontalSpeed,
            horizontalDegree,
            verticalSpeed,
            verticalDegree
        )
    }

    /**
     * This [resetPosition] function is supported on PodX
     */
    override fun resetPosition() {
        controller.resetPositionHorizontally()
    }

    /**
     * This [moveVertically] function is supported on PodX
     */
    override fun moveVertically(direction: VerticalDirection, degree: Int, speed: Speed) {
        controller.moveVertically(direction, speed, degree)
    }

    override fun moveHorizontally(direction: HorizontalDirection, degree: Int, speed: Speed) {
        controller.moveHorizontally(direction, speed, degree)
    }

    override fun moveHorizontallyContinuously(direction: HorizontalDirection, speed: Speed) {
        controller.moveHorizontally(direction, speed, 0)
    }

    override fun moveHorizontally(direction: HorizontalDirection, degree: Int, speed: LegacySpeed) {
        controller.moveHorizontally(direction, speed, degree)
    }

    override fun moveHorizontallyContinuously(direction: HorizontalDirection, speed: LegacySpeed) {
        controller.moveHorizontally(direction, speed, 0)
    }

    override fun getHorizontalSpeedsInSecPerRound(): IntArray {
        return controller.getHorizontalSupportedSpeedsInSecondsPerRound()
    }

    override fun stop() {
        controller.stop()
    }

    override fun getDeviceInfo() = controller.getDeviceInfo()

    override fun requestDeviceInfo() = controller.requestDeviceInfo()

    override fun requestMacAddress() {
        controller.requestMacAddress()
    }

    override fun keepAlive(alive: Boolean, scope: CoroutineScope) {
        controller.keepAlive(alive, scope)
    }

    override fun requestSerialNumber() {
        controller.requestSerialNumber()
    }

    override fun requestBattery() {
        controller.requestBatteryLevel()
    }

    override fun changeName(name: String) {
        controller.changeName(name)
    }

    override fun setSpeedForVertical(speed: Speed) {
        controller.setVerticalMotorSpeed(speed)
    }

    override fun setSpeedForHorizontal(speed: Speed) {
        controller.setHorizontalMotorSpeed(speed)
    }

    override fun goToVerticalPosition(speed: Speed, degree: Int) {
        controller.moveToSpecificVerticalPosition(speed, degree)
    }

    override fun gotoHorizontalPosition(speed: Speed, degree: Int) {
        controller.moveToSpecificHorizontalPosition(speed, degree)
    }

    /**
     * This [resetHorizontalPosition] function is supported on PodX
     */
    override fun resetHorizontalPosition() {
        controller.resetPositionHorizontally()
    }

    /**
     * This [getVerticalPosition] function is supported on PodX
     */
    override fun getVerticalPosition() {
        controller.getVerticalPosition()
    }

    /**
     * This [getHorizontalPosition] function is supported on PodX
     */
    override fun getHorizontalPosition() {
        controller.getHorizontalPosition()
    }

    /**
     * This [getCurrentLEDColors] function is supported on PodX
     */
    override fun getCurrentLEDColors() {
        controller.getLEDColor()
    }

    /**
     * This [setLEDColor] function is supported on PodX
     */
    override fun setLEDColor(colors: CurrentLED) {
        controller.setLED(colors)
    }

    override fun makeSound(sound: SoundType) {
        controller.makeBeamSound(sound)
    }

    override fun setConnectionTimeout(timeInSecond: Int) {
        controller.setConnectionTimeout(timeInSecond)
    }

    override fun enableRemoteController(enabled: Boolean) {
        controller.enableRemoteController(enabled)
    }

    override fun enableNotifier(enabled: Boolean) {
        controller.enableMovementNotifier(enabled)
    }

    override fun startPairing() {
        controller.startPairing()
    }

    override fun cancelPairing() {
        controller.cancelPairing()
    }

    override fun runLightPreset(patternType: LightPatternType, level: Int) {
        controller.runLEDPreset(patternType, level)
    }

    override fun stopLightPreset() {
        controller.stopLEDPreset()
    }

    override fun upgradeFirmware(bytes: ByteArray, otaPacketSize: Int) {
        controller.initiateOTA(bytes, otaPacketSize)
    }

    override fun authenticatePod(wrongAuthentication: Boolean) {
        controller.authPod(wrongAuthentication)
    }

    override fun holdTurningHorizontally() {
        controller.holdTurningHorizontally()
    }

    override fun registerOnPodListener(listener: OnPodListener) {
        controller.registerOnPodListener(listener)
    }

    override fun registerBatteryListener(listener: OnBatteryListener) {
        controller.registerBatteryListener(listener)
    }

    override fun registerConnectivityListener(listener: OnConnectionControllerListener) {
        controller.registerConnectivityListener(listener)
    }

    override fun registerDeviceInfoListener(listener: OnDeviceInfoListener) {
        controller.registerDeviceInfoListener(listener)
    }

    override fun registerBeamSoundListener(listener: OnBeamSoundListener) {
        controller.registerBeamSoundListener(listener)
    }

    override fun registerOnLEDListener(listener: OnLEDListener) {
        controller.registerOnLEDListener(listener)
    }

    override fun registerDeviceStatusListener(listener: OnDeviceStatusListener) {
        controller.registerDeviceStatusListener(listener)
    }

    override fun registerOTAUpdateListener(listener: OnOTAStatusListener) {
        controller.registerOTAUpdateListener(listener)
    }

    override fun registerMovementListener(listener: OnMovementControlListener) {
        controller.registerMovementListener(listener)
    }

    override fun registerRemoteControllerListener(listener: OnRemoteControllerListener) {
        controller.registerRemoteControllerListener(listener)
    }

    override fun unregisterConnectivityListener(listener: OnConnectionControllerListener) {
        controller.unregisterConnectivityListener(listener)
    }

    override fun unregisterRemoteControllerListener(listener: OnRemoteControllerListener) {
        controller.unregisterRemoteControllerListener(listener)
    }

    override fun unregisterMovementListener(listener: OnMovementControlListener) {
        controller.unregisterMovementListener(listener)
    }

    override fun unregisterOTAUpdateListener(listener: OnOTAStatusListener) {
        controller.unregisterOTAUpdateListener(listener)
    }

    override fun unregisterDeviceInfoListener(listener: OnDeviceInfoListener) {
        controller.unregisterDeviceInfoListener(listener)
    }

    override fun unregisterOnPodListener(listener: OnPodListener) {
        controller.unregisterOnPodListener(listener)
    }

    override fun unregisterBeamSoundListener(listener: OnBeamSoundListener) {
        controller.unregisterBeamSoundListener(listener)
    }

    override fun unregisterOnLEDListener(listener: OnLEDListener) {
        controller.unregisterOnLEDListener(listener)
    }

    override fun unregisterDeviceStatusListener(listener: OnDeviceStatusListener) {
        controller.unregisterDeviceStatusListener(listener)
    }

    override fun unregisterBatteryListener(listener: OnBatteryListener) {
        controller.unregisterBatteryListener(listener)
    }

    override fun registerAuthenticationListener(listener: OnAuthenticationListener) {
        controller.registerAuthenticationListener(listener)
    }

    override fun unregisterAuthenticationListener(listener: OnAuthenticationListener) {
        controller.unregisterAuthenticationListener(listener)
    }
}