package app.pivo.android.podsdk.cmd.parser.impl.podmax

import app.pivo.android.podsdk.model.SerialNumber
import app.pivo.android.podsdk.cmd.parser.impl.Reply
import app.pivo.android.podsdk.model.PivoDeviceCategory
import app.pivo.android.podsdk.util.HexUtil

/**
 * Created by murodjon on 2021/05/27
 */
class SerialNumberReply(private val bytes: ByteArray, private val deviceCategory: PivoDeviceCategory) : Reply<SerialNumber> {
    override fun getData() =
        getSerialNumber()?.let { SerialNumber(it) }

    private fun getSerialNumber(): String? {
        val serialNumberBytes = getSerialNumberBytes(bytes)
        return if (serialNumberBytes != null) {
            convertBytesToReadableSerialNumber(serialNumberBytes)
        } else returnNoSerialNumProvided()
    }

    private fun getSerialNumberBytes(data: ByteArray): ByteArray? {
        return if (isValidSerialNumberBytes(data)) {
            data.copyOfRange(6, 18)
        } else {
            null
        }
    }

    private fun isValidSerialNumberBytes(data: ByteArray): Boolean {
        return data.size == 18
    }

    private fun convertBytesToReadableSerialNumber(data: ByteArray): String {
        val serialNum = StringBuilder()
        for (i in data.indices) {
            if (i <= 2 || i in 4..5) serialNum.append(data[i].toInt().toChar()) else if (i == 3) {
                serialNum.append(data[i])
            } else {
                serialNum.append(String.format("%02X", data[i]))
            }
        }
        return serialNum.toString()
    }

    private fun returnNoSerialNumProvided(): String {
        return "No Serial Number Provided"
    }

    companion object {
        fun isSerialNumberReply(bytes: ByteArray) =
            bytes.size >= 18
                    && bytes[3] == 0x49.toByte()
                    && bytes[4] == 0x1C.toByte()
    }
}