package app.pivo.android.prosdk;

import app.pivo.android.prosdk.exceptions.*;
import app.pivo.android.prosdk.util.Degree;
import app.pivo.android.prosdk.util.PivoDevice;
import app.pivo.android.prosdk.util.Sound;
import app.pivo.android.prosdk.util.Version;

abstract class IPivoController {
    abstract void getLicenseContent(String content) throws LicenseDateException, PackageNameException, InvalidLicenseException, SdkPlanTypeException;

    abstract boolean isVerified();

    abstract void scan();

    abstract void connectTo(PivoDevice pivoDevice);

    abstract void stopScan();

    abstract void disconnect();

    abstract int[] getSupportedSpeedsInSecondsPerRound();

    abstract int[] getSupportedSpeedsByRemoteInSecondsPerRound();

    abstract void turnLeft(int angle);

    abstract void turnLeft(int angle, int speed);

    abstract void turnRight(int angle);

    abstract void turnRight(int angle, int speed);

    abstract void turnRightContinuously();

    abstract void turnRightContinuously(int speed);

    abstract void turnLeftContinuously();

    abstract void turnLeftContinuously(int speed);

    abstract void requestBatteryLevel();

    abstract void stop();

    abstract void changeName(String name);

    abstract void changeSpeed(int speed);

    abstract boolean isPivoConnected();

    @Deprecated
    abstract String getPivoVersion();

    abstract Version getVersion();

    abstract void turnOnNotification();

    abstract void turnOffNotification();

    abstract void changeMode();

    abstract void startPairingMode();

    abstract void cancelPairingMode();

    abstract void makeBeepSound(Sound sound);

    abstract void changeMinRotationDegree(Degree degree);

    abstract void getMacAddress();

    abstract void keepAlive(boolean alive);
//
//    abstract void setTimeout(int sec);
}
