package app.pivo.android.prosdk;

import app.pivo.android.prosdk.util.PivoType;
import app.pivo.android.prosdk.util.Version;

class PivoRotatorConfig {

    final float MARGIN = 0.05f; // 5% of Preview width (it can be adjust to increase the sensitivity later)
    private float KP; //Increase the responsiveness
    private float KD; //Prevent the overshooting

    private double mZoom;

    float minSpeed;
    float maxSpeed;

    float maxDegree;

    Version version = new Version(0, PivoType.RED);

    private int lowerIdx, upperIdx;
    float scaleFactor;

    private static PivoRotatorConfig instance;

    private final float [] angularSpeeds = {36, 18, 12, 7.2f, 6, 3, 1.2f, 0.6f}; // For version 0 of Pivo
    private final Rotator.Speed[] mSpeeds = {
            Rotator.Speed.SPEED_1,
            Rotator.Speed.SPEED_2,
            Rotator.Speed.SPEED_3,
            Rotator.Speed.SPEED_4,
            Rotator.Speed.SPEED_5,
            Rotator.Speed.SPEED_6,
            Rotator.Speed.SPEED_7,
            Rotator.Speed.SPEED_8
    };


    private SensitivityMode sensitivityMode;

    void initConfig(double zoom, SensitivityMode mode, Version version){
        sensitivityMode = mode;
        mZoom = zoom;
        this.version = version;

        if(version.getVersion() == 0) {
            setSpeedBoundariesV0(); // For sensitivity modes speed boundaries for V0

            KD = mode.getKDValue();
            KP = mode.getKPValue();
            lowerIdx = mode.getLowerIndex();
            upperIdx = mode.getUpperIndex();

            minSpeed = angularSpeeds[upperIdx];
            maxSpeed = angularSpeeds[lowerIdx];
            scaleFactor = maxSpeed - minSpeed;
        }
        else if(version.isAboveV0()) {
            setSpeedBoundariesV1(); // For sensitivity modes speed boundaries for V1

            KD = mode.getKDValue();
            KP = mode.getKPValue();

            maxSpeed = mode.getV1MaxHalfSpeed();
            maxDegree = 180.0f / maxSpeed;
            scaleFactor = maxDegree - (180.0f/mode.getV1MinHalfSpeed()); // (90 - 3)degPerSec // 360/4 - 360/120
        }
    }

    public static PivoRotatorConfig getInstance () {
        if (instance == null) {
            instance = new PivoRotatorConfig();
            return instance;
        }
        return instance;
    }


    /***Getters***/
    SensitivityMode getSensitivityMode(){
        return sensitivityMode;
    }

    int getLowerIdx() {
        return lowerIdx;
    }

    int getUpperIdx() {
        return upperIdx;
    }

    int getMaxSpeedIndex() {
        return lowerIdx;
    } // Same with getLowerIdx but different Naming

    int getMinSpeedIndex() {
        return upperIdx;
    }

    Rotator.Speed[] getSpeeds() {
        return mSpeeds;
    }

    float[] getAngularSpeeds() {
        return angularSpeeds;
    }

    float getKD() {
        return KD;
    }

    float getKP() {
        return KP;
    }

    public double getZoom (){
        return mZoom;
    }

    public Version getVersion() {
        return version;
    }

    /***Setters***/
    void setKD(float KD) {
        this.KD = KD;
    }

    void setKP(float KP) {
        this.KP = KP;
    }



    /*******/

    private void setSpeedBoundariesV0() {
        if (mZoom < 2.0) {
            SensitivityMode.FAST.setLowerIndex(0);
            SensitivityMode.FAST.setUpperIndex(4);
            SensitivityMode.FAST.setKPValue(2.8f);
            SensitivityMode.FAST.setKDValue(0.5f);

            SensitivityMode.NORMAL.setLowerIndex(0);
            SensitivityMode.NORMAL.setUpperIndex(5);
            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);

            SensitivityMode.SLOW.setLowerIndex(1);
            SensitivityMode.SLOW.setUpperIndex(6);
            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
        }
        else if (mZoom < 3.0) {
            SensitivityMode.FAST.setLowerIndex(1);
            SensitivityMode.FAST.setUpperIndex(5);
            SensitivityMode.FAST.setKPValue(2.6f);
            SensitivityMode.FAST.setKDValue(0.5f);

            SensitivityMode.NORMAL.setLowerIndex(1);
            SensitivityMode.NORMAL.setUpperIndex(6);
            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);

            SensitivityMode.SLOW.setLowerIndex(1);
            SensitivityMode.SLOW.setUpperIndex(7);
            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
        }
        else {
            SensitivityMode.FAST.setLowerIndex(1);
            SensitivityMode.FAST.setUpperIndex(6);
            SensitivityMode.FAST.setKPValue(2.4f);
            SensitivityMode.FAST.setKDValue(0.6f);

            SensitivityMode.NORMAL.setLowerIndex(1);
            SensitivityMode.NORMAL.setUpperIndex(6);
            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.5f);

            SensitivityMode.SLOW.setLowerIndex(2);
            SensitivityMode.SLOW.setUpperIndex(7);
            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.5f);
        }
    }

    private void setSpeedBoundariesV1() {
        if (mZoom < 2.0) {
            SensitivityMode.FAST.setKPValue(2.8f);
            SensitivityMode.FAST.setKDValue(0.4f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(5); // 10 sec/rnd --> 36 deg/sec
            SensitivityMode.FAST.setV1MinHalfSpeed(40);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(5);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(60);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(10); // 20 sec/rnd --> 18 deg/sec
            SensitivityMode.SLOW.setV1MinHalfSpeed(140);
        }
        else if (mZoom < 3.0) {
            SensitivityMode.FAST.setKPValue(2.6f);
            SensitivityMode.FAST.setKDValue(0.4f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(8);
            SensitivityMode.FAST.setV1MinHalfSpeed(80);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(8);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(90);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(12);
            SensitivityMode.SLOW.setV1MinHalfSpeed(170);
        }
        else {
            SensitivityMode.FAST.setKPValue(2.4f);
            SensitivityMode.FAST.setKDValue(0.5f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(10);
            SensitivityMode.FAST.setV1MinHalfSpeed(120);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.5f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(11);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(240);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.5f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(14);
            SensitivityMode.SLOW.setV1MinHalfSpeed(200);
        }
    }

    private void setSpeedBoundariesV2() {
        if (mZoom < 2.0) {
            SensitivityMode.FAST.setKPValue(2.0f);
            SensitivityMode.FAST.setKDValue(0.6f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(3); // 4 sec/rnd --> 90 deg/sec
            SensitivityMode.FAST.setV1MinHalfSpeed(30);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(5);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(60);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(10); // 20 sec/rnd --> 18 deg/sec
            SensitivityMode.SLOW.setV1MinHalfSpeed(140);
        }
        else if (mZoom < 3.0) {
            SensitivityMode.FAST.setKPValue(1.9f);
            SensitivityMode.FAST.setKDValue(0.7f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(5);
            SensitivityMode.FAST.setV1MinHalfSpeed(50);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.4f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(8);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(90);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.4f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(12);
            SensitivityMode.SLOW.setV1MinHalfSpeed(170);
        }
        else {
            SensitivityMode.FAST.setKPValue(1.6f);
            SensitivityMode.FAST.setKDValue(0.8f);
            SensitivityMode.FAST.setV1MaxHalfSpeed(6);
            SensitivityMode.FAST.setV1MinHalfSpeed(70);

            SensitivityMode.NORMAL.setKPValue(1.8f);
            SensitivityMode.NORMAL.setKDValue(0.5f);
            SensitivityMode.NORMAL.setV1MaxHalfSpeed(11);
            SensitivityMode.NORMAL.setV1MinHalfSpeed(240);

            SensitivityMode.SLOW.setKPValue(1.0f);
            SensitivityMode.SLOW.setKDValue(0.5f);
            SensitivityMode.SLOW.setV1MaxHalfSpeed(14);
            SensitivityMode.SLOW.setV1MinHalfSpeed(200);
        }
    }

}
