package app.pivo.android.prosdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Base64;

import org.json.JSONException;
import org.json.JSONObject;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

import app.pivo.android.prosdk.exceptions.*;

class Verifier implements IVerify{

    private final Context context;
    private String data;
    private String mSignature;
    private boolean verified;
    private PublicKey publicKey;

    Verifier(Context context){
        this.context = context;
    }

    public String readLicense(String lContent)throws InvalidLicenseException, LicenseDateException, PackageNameException, SdkPlanTypeException {
        publicKey = t2PK(getPublicKey(context.getAssets()));
        try{
            JSONObject obj = new JSONObject(lContent);

            mSignature = obj.getString("signature");

            obj.remove("signature");
            data = obj.toString();

            verified = verify(obj);
            return data;
        }catch (JSONException e){
            throw new InvalidLicenseException("Invalid license is provided.");
        }
    }

    public PublicKey t2PK(String pk_in_t)
    {
        try {
            byte[] keyBytes = Base64.decode(pk_in_t, Base64.DEFAULT);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(getType());
            return keyFactory.generatePublic(spec);
        } catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            e.printStackTrace();
            return null;
        }
    }

     public boolean isValid(){
        if (data == null || mSignature == null)return false;
        try {
            Signature s = Signature.getInstance(getFunc());
            s.initVerify(publicKey);
            s.update(data.getBytes());

            return s.verify(Base64.decode(mSignature, Base64.DEFAULT))&&verified;
        }catch (Exception e){
            return false;
        }
    }

    private boolean verify(JSONObject jsonData) throws PackageNameException, LicenseDateException, SdkPlanTypeException, JSONException{
        boolean packageNameExist = jsonData.has("appIdentifier");
        if (!packageNameExist || !context.getPackageName().equals(jsonData.getString("appIdentifier"))){
            throw new PackageNameException("Verify the package name.");
        }

        boolean planExist = jsonData.has("plan");
        if (!planExist || !("pro").equalsIgnoreCase(jsonData.getString("plan"))){
            throw new SdkPlanTypeException("Wrong sdk plan is provided or missing in license");
        }

        long tsLong = System.currentTimeMillis()/1000;
        if (Long.parseLong(jsonData.getString("expiredAt")) - tsLong <0) {
            throw new LicenseDateException("The Licence key is expired.");
        }

        if (Long.parseLong(jsonData.getString("createdAt")) - tsLong > 0){
            throw new LicenseDateException("The creation date is not consistent.");
        }else if (Long.parseLong(jsonData.getString("expiredAt")) - Long.parseLong(jsonData.getString("createdAt"))<0){
            throw new LicenseDateException("The creation date is greater than the expiration date.");
        }
        return true;
    }

    native String getPublicKey(AssetManager assetManager);

    native String getType();

    native String getFunc();

    static {
        System.loadLibrary("verifier-lib");
    }
}

