package app.pivo.android.prosdk;

import app.pivo.android.prosdk.exceptions.*;
import app.pivo.android.prosdk.util.Degree;
import app.pivo.android.prosdk.util.PivoDevice;
import app.pivo.android.prosdk.util.PivoDeviceInfo;
import app.pivo.android.prosdk.util.Sound;
import app.pivo.android.prosdk.util.Version;

abstract class IPivoController {
    abstract void enableLog(boolean enabled);

    abstract void getLicenseContent(String content) throws LicenseDateException, PackageNameException, InvalidLicenseException, SdkPlanTypeException;

    abstract boolean isVerified();

    abstract void scan();

    abstract void connectTo(PivoDevice pivoDevice);

    abstract void stopScan();

    abstract void disconnect();

    abstract int[] getSupportedSpeeds();

    abstract int[] getSupportedSpeedsWithFeedback();

    abstract void turnLeft(int angle);

    abstract void turnLeft(int angle, int speed) throws UnsupportedSpeedException;

    abstract void turnRight(int angle);

    abstract void turnRight(int angle, int speed) throws UnsupportedSpeedException;

    abstract void turnRightContinuously();

    abstract void turnRightContinuously(int speed) throws UnsupportedSpeedException;

    abstract void turnLeftContinuously();

    abstract void turnLeftContinuously(int speed) throws UnsupportedSpeedException;

    abstract void turnLeftWithFeedback(int angle, int speed) throws UnsupportedSpeedException;

    abstract void turnRightWithFeedback(int angle, int speed) throws UnsupportedSpeedException;

    abstract void requestBatteryLevel();

    abstract void stop();

    abstract void turnHold();

    abstract void changeName(String name);

    abstract void changeSpeed(int speed);

    abstract void changeSpeedRemote(int speed);

    abstract boolean isPivoConnected();

    @Deprecated
    abstract String getPivoVersion();

    abstract Version getVersion();

    abstract PivoDeviceInfo getDeviceInfo();

    abstract void turnOnNotification();

    abstract void turnOffNotification();

    abstract void changeMode();

    abstract void startPairingMode();

    abstract void cancelPairingMode();

    abstract void makeBeepSound(Sound sound);

    abstract void changeMinRotationDegree(Degree degree);

    abstract void setTimeout(int sec);

    abstract void keepAlive(boolean alive);

    abstract void enableBypass(boolean on);

    abstract boolean isBypassOn();

    abstract boolean isBypassSupported();
}
