package app.pivo.android.prosdk;

import android.graphics.Rect;
import android.media.Image;

import app.pivo.android.prosdk.tracking.FrameMetadata;
import app.pivo.android.prosdk.util.ITrackingListener;

/**
 * Created by murodjon on 2020/04/16
 */
interface IFrameProcessingTask {

    void update(Image image, FrameMetadata metadata);

    void update(byte[] image, FrameMetadata metadata);

    void startPersonTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);

    void startHorseTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);

    void startActionTracking(FrameMetadata frameMetadata, Rect region, Image image, ITrackingListener listener);

    void startActionTracking(FrameMetadata frameMetadata, Rect region, byte[] image, ITrackingListener listener);

    void startPersonTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);

    void startHorseTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);

    void stopTracking();

    void setTargetToTrack(Rect rect);

    MultiBoxTracker getTracker();
}
