package app.pivo.android.prosdk;

/**
 * This enum is used to control Pivo tracking sensitivity.
 * {@link PivoSensitivity#NONE} performs only tracking without Pivo rotation;
 * {@link PivoSensitivity#NORMAL} tracks while moving in normal pace
 * {@link PivoSensitivity#SLOW} tracks while moving in slow pace
 * {@link PivoSensitivity#FAST} tracks while moving in fast pace
 */
public enum PivoSensitivity {
    /**
     * {@link PivoSensitivity#NONE} performs only tracking without Pivo rotation;
     */
    NONE(-1),
    /**
     * {@link PivoSensitivity#NORMAL} tracks while moving in normal pace
     */
    NORMAL(0),
    /**
     * {@link PivoSensitivity#SLOW} tracks while moving in slow pace
     */
    SLOW (1),
    /**
     *  {@link PivoSensitivity#FAST} tracks while moving in fast pace
     */
    FAST (2);

    PivoSensitivity (int mode){
        this.mode = mode;
    }

    private int mode;
    int getMode() {
        return mode;
    }
}
