package app.pivo.android.prosdk;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.media.Image;
import android.util.Log;

import app.pivo.android.basicsdk.PivoSdk;
import app.pivo.android.prosdk.tracking.FrameMetadata;
import app.pivo.android.prosdk.util.ITrackingListener;

public class PivoProSdk extends PivoSdk {

    private final String TAG = this.getClass().getSimpleName();
    static PivoProSdk instance;
    private final IFrameProcessingTask frameProcessing;

    private FrameMetadata frameMetadata;

    private SensitivityMode sensitivityMode = SensitivityMode.NORMAL;

    //PivoProSdk singleton 객체 get
    public static PivoProSdk getInstance(){
        return instance;
    }

    //Application에서 SDK 사용을 위해 초기화 fun. SDK 사용전 반드시 호출해야 함.
    public static void init(Context context){
        instance = new PivoProSdk(context);
    }

    PivoProSdk(Context context){
        // frame processing tasks
        frameProcessing = new FrameProcessingTask
                .Builder()
                .setContext(context)
                .build();

       PivoSpeedController.getInstance().setController(this);

    }

    //SDK에서 지원되는 Tracking Mode
    public String[] getSupportedTrackingModes() {
        return new String[]{"Action", "Person", "Horse"};
    }

    //Action Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    region : target region
    image : android camera frame data wrapper class
    sensitivity : sensitivity about action
    listener : tracking callback listener
     */
    public void startActionTracking(FrameMetadata metadata, Rect region, Image image,PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || region==null || listener == null || metadata == null || sensitivity == null){
            Log.e(TAG, "startActionTracking() ->  Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startActionTracking(metadata, region, image, mListener);
        }
    }

    //Action Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    region : target region
    image : camera frame data in byte array
    sensitivity : sensitivity about action
    listener : tracking callback listener
     */
    public void startActionTracking(FrameMetadata metadata, Rect region, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || region==null || listener == null || metadata == null || sensitivity == null){
            Log.e(TAG, "startActionTracking() ->  Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startActionTracking(metadata, region, image, mListener);
        }
    }

    //Action Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : android camera frame data wrapper class
    sensitivity : sensitivity about action
    listener : tracking callback listener
    */
    public void starPersonTracking(FrameMetadata metadata, Image image,PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "starPersonTracking() -> Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startPersonTracking(metadata, image, mListener);
        }
    }

    //Action Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : camera frame data in byte array
    sensitivity : sensitivity about action
    listener : tracking callback listener
    */
    public void starPersonTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "starPersonTracking() -> Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startPersonTracking(metadata, image, mListener);
        }
    }

    //Horse Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : android camera frame data wrapper class
    sensitivity : sensitivity about action
    listener : tracking callback listener
    */
    public void startHorseTracking(FrameMetadata metadata, Image image,PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || listener == null || metadata==null || sensitivity == null){
            Log.e(TAG, "startHorseTracking() -> Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startHorseTracking(metadata, image, mListener);
        }
    }

    //Horse Tracking 하기. 첫번째 프레임에서만 사용
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : camera frame data in byte array
    sensitivity : sensitivity about action
    listener : tracking callback listener
    */
    public void startHorseTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) {
        if (image==null || listener == null || metadata==null || sensitivity == null){
            Log.e(TAG, "startHorseTracking() -> Some of the arguments you're sending is null.");
            return;
        }
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
        }
        frameMetadata = metadata;
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startHorseTracking(metadata, image, mListener);
        }
    }

    //Stop tracking Process
    public void stopTracking(){
        frameProcessing.stopTracking();
    }

    /*
    todo : Refactoring 필요 !!! [comment by kris]
     - start tracking 부분들 모두 삭제 필요 - 초기화로 변경
     - Frame 처리는 updateTrackingFrame method로 모두 대체
     */
    //모든 Tracking 모드의 2번째 Frame부터 해당 method를 사용한다.
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : android camera frame data wrapper class
     */
    public void updateTrackingFrame(Image image, FrameMetadata metadata) {
        if (image==null){
            Log.e(TAG, "updateTrackingFrame()-> Image object is null");
            return;
        }
        if (isVerified()){
            frameMetadata = metadata;
            frameProcessing.update(image, metadata);
        }
    }

    //모든 Tracking 모드의 2번째 Frame부터 해당 method를 사용한다.
    /*
    metadata : frame meta data. (width, height, front or back camera option, orientation, rotation...)
    image : camera frame data in byte array
     */
    public void updateTrackingFrame(byte[] image, FrameMetadata metadata) {
        if (image==null){
            Log.e(TAG, "updateTrackingFrame()-> Image object is null");
            return;
        }
        if (isVerified()){
            frameMetadata = metadata;
            frameProcessing.update(image, metadata);
        }
    }

    private ITrackingListener outListener;
    private final ITrackingListener mListener = new ITrackingListener() {

        @Override
        public void onTracking(int x, int y, int width, int height, int frameWidth, int frameHeight) {
            Rect rect = new Rect(x, y, x + width, y + height);
            frameProcessing.setTargetToTrack(rect);

            if (frameProcessing.getTracker() != null) {
                outListener.onTracking(frameProcessing.getTracker().draw());
            }

            outListener.onTracking(x, y, width, height, frameWidth, frameHeight);

            PivoSpeedController.getInstance()
                    .setCameraFacing(frameMetadata.isFrontCamera())
                    .setSensitivityMode(sensitivityMode)
                    .setOrientation(frameMetadata.getRotation())
                    .setOrientationLocked(frameMetadata.isOrientationLocked())
                    .setPositionType(PositionType.MIDDLE)
                    .setPreviewSize(frameWidth,frameHeight)
                    .track(new PointF(x + width / 2.f, y + height / 2.f));
        }

        @Override
        public void onClear() {
            outListener.onClear();
        }
    };
}
