/*
 * Decompiled with CFR 0.152.
 */
package app.playerzero.sdk.log4j;

import app.playerzero.sdk.PzApi;
import app.playerzero.sdk.PzEventType;
import app.playerzero.sdk.PzOptions;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="PzSdkAppender", category="Core", elementType="appender", printObject=true)
public class PzSdkAppender
extends AbstractAppender {
    private final String apiToken;
    private final boolean prod;
    private final String dataset;
    private final String endpoint;
    private PzApi sdk;

    protected PzSdkAppender(String name, Layout<? extends Serializable> layout, String apiToken, String dataset, String prod, String endpoint) {
        super(name, null, layout, false, Property.EMPTY_ARRAY);
        System.out.printf("Name=%s, Token=%s, Dataset=%s\n", name, apiToken, dataset);
        this.apiToken = apiToken;
        this.prod = prod == null || "true".equalsIgnoreCase(prod);
        this.dataset = dataset;
        this.endpoint = endpoint;
    }

    @PluginFactory
    public static PzSdkAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="apiToken") String apiToken, @PluginAttribute(value="dataset") String dataset, @PluginAttribute(value="prod") String prod, @PluginAttribute(value="endpoint") String endpoint) {
        System.out.printf("Name=%s, Other Attribute=%s\n", name, apiToken);
        if (name == null) {
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new PzSdkAppender(name, (Layout<? extends Serializable>)layout, apiToken, dataset, prod, endpoint);
    }

    public void append(LogEvent event) {
        String levelStr = event.getLevel().name();
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        event.getContextData().forEach(metadata::put);
        if ("ERROR".equals(levelStr)) {
            this.sdk.pendingEvent(PzEventType.Signal).setSubtype(levelStr).setSignalTitle(event.getMessage().getFormattedMessage()).setSignalError(event.getThrown()).setMetadata(metadata).setTs(new Date(event.getInstant().getEpochMillisecond())).send();
        } else if (!"OFF".equals(levelStr)) {
            this.sdk.pendingEvent(PzEventType.Logged).setSubtype(levelStr).setValue(event.getMessage().getFormattedMessage()).setMetadata(metadata).setTs(new Date(event.getInstant().getEpochMillisecond())).send();
        }
    }

    public void start() {
        this.sdk = new PzApi(this.apiToken, new PzOptions().setDataset(this.dataset).setProd(this.prod).setEndpoint(this.endpoint));
        super.start();
    }
}

