/*
 * Decompiled with CFR 0.152.
 */
package app.playerzero.sdk;

import app.playerzero.sdk.PzEvent;
import app.playerzero.sdk.PzEventOptions;
import app.playerzero.sdk.PzEventType;
import app.playerzero.sdk.PzIdentity;
import app.playerzero.sdk.PzOptions;
import app.playerzero.sdk.PzPendingEvent;
import app.playerzero.sdk.PzSignalOptions;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PzApi {
    private static final String SDK_VERSION = "Java " + PzApi.class.getPackage().getImplementationVersion();
    private static final Pattern CHECKS = Pattern.compile("\\b\\d{3}-?\\d{2}-?\\d{4}\\b|\\b(?:\\d{3,4}[ -]?){4}\\b", 8);
    private static final Logger logger = LoggerFactory.getLogger(PzApi.class);
    private static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final WeakHashMap<String, PzApi> instances = new WeakHashMap();
    private final String apiToken;
    private final String dataset;
    private final Boolean prod;
    private final ThreadLocal<PzIdentity> identification = new InheritableThreadLocal<PzIdentity>();
    private final Integer batchEventsSize;
    private final Integer debounceInMs;
    private final Function<String, String> privacy;
    private final String endpoint;
    private final Supplier<String> eventIdGenerator;
    private final Map<String, Object> eventProperties;
    private final Consumer<PzEvent> queuedEvent;
    private final Consumer<Collection<PzEvent>> dequeuedEvents;
    private final WeakHashMap<Queue<PzEvent>, Future<?>> debounceRefs = new WeakHashMap();
    private volatile Queue<PzEvent> eventQ = new ConcurrentLinkedQueue<PzEvent>();

    private PzApi(String apiToken, PzOptions options) {
        this.apiToken = apiToken;
        PzOptions o = options == null ? new PzOptions() : options;
        this.dataset = o.dataset;
        this.prod = o.prod;
        this.batchEventsSize = o.batchEventsSize;
        this.debounceInMs = o.debounceInMs;
        this.privacy = o.privacy;
        this.endpoint = o.endpoint + "/data";
        this.eventIdGenerator = o.eventIdGenerator == null ? () -> UUID.randomUUID().toString() : o.eventIdGenerator;
        this.eventProperties = o.eventProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(o.eventProperties);
        this.queuedEvent = o.queuedEvent;
        this.dequeuedEvents = o.dequeuedEvents;
        if (o.restoreQueue != null) {
            o.restoreQueue.get().whenCompleteAsync((pzEvents, throwable) -> {
                if (pzEvents != null && !pzEvents.isEmpty()) {
                    this.eventQ.addAll((Collection<PzEvent>)pzEvents);
                }
            });
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.flushEventQ().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    public static PzApi getInstance(String apiToken) {
        return PzApi.getInstance(apiToken, null);
    }

    public static synchronized PzApi getInstance(String apiToken, PzOptions options) {
        return instances.computeIfAbsent(apiToken, token -> new PzApi((String)token, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withIdentify(Map<String, String> actors, Map<String, Object> metadata, Runnable action) {
        PzIdentity current = this.identification.get();
        try {
            this.identify(actors, metadata);
            action.run();
        }
        finally {
            this.identification.set(current);
        }
    }

    public void identify(String id) {
        this.identify(id, null);
    }

    public void identify(String id, Map<String, Object> metadata) {
        HashMap<String, String> ids = null;
        if (id != null) {
            ids = new HashMap<String, String>();
            ids.put("UserId", id);
        }
        this.identify(ids, metadata);
    }

    public void identify(Map<String, String> actors) {
        this.identify(actors, null);
    }

    public void identify(Map<String, String> actors, Map<String, Object> metadata) {
        if (actors == null) {
            this.identification.remove();
        } else {
            this.identification.set(new PzIdentity(actors, metadata));
        }
    }

    public PzPendingEvent pendingEvent(PzEventType type) {
        return new PzPendingEvent(type, this.identification.get(), this.eventProperties, this::publishEvents, this::privatizeText, this.eventIdGenerator);
    }

    public void track(String name) {
        this.track(name, null);
    }

    public void track(String name, PzEventOptions options) {
        PzIdentity identity = this.identification.get();
        if (identity == null || identity.actors.isEmpty()) {
            Exception e = new Exception();
            StackTraceElement src = Arrays.stream(e.getStackTrace()).filter(elem -> !elem.getClassName().equals(PzApi.class.getName())).findFirst().get();
            logger.warn("Tracked event '{}' at {}:{} discarded due to lack of identification", new Object[]{name, src.getFileName(), src.getLineNumber()});
            return;
        }
        PzPendingEvent eventToSend = this.newEvent(PzEventType.Tracked, options == null ? null : options.metadata);
        eventToSend.setSubtype(options == null ? null : options.type);
        eventToSend.setValue(this.privatizeText(name));
        eventToSend.send();
    }

    public void log(String message) {
        this.log(message, null);
    }

    public void log(String message, PzEventOptions options) {
        PzPendingEvent eventToSend = this.newEvent(PzEventType.Logged, options == null ? null : options.metadata);
        eventToSend.setSubtype(options == null ? null : options.type);
        eventToSend.setValue(this.privatizeText(message));
        eventToSend.send();
    }

    public void signal(String reason) {
        this.signal(reason, null, null);
    }

    public void signal(Throwable error) {
        this.signal(null, error, null);
    }

    public void signal(String reason, PzSignalOptions options) {
        this.signal(reason, null, options);
    }

    public void signal(Throwable error, PzSignalOptions options) {
        this.signal(null, error, options);
    }

    public void signal(String reason, Throwable error) {
        this.signal(reason, error, null);
    }

    public void signal(String reason, Throwable error, PzSignalOptions options) {
        PzSignalOptions o;
        if (reason == null && error == null) {
            return;
        }
        PzSignalOptions pzSignalOptions = o = options != null ? options : new PzSignalOptions();
        if (reason == null) {
            reason = o.reason;
        }
        if (error == null) {
            error = o.error;
        }
        String message = reason;
        if (reason == null) {
            message = error.getMessage();
            if ((message == null || message.trim().isBlank()) && error.getCause() != null) {
                message = error.getCause().getMessage();
            }
            if (message == null || message.trim().isBlank()) {
                message = error.getClass().getName();
            }
        }
        PzPendingEvent eventToSend = this.newEvent(PzEventType.Signal, o.metadata);
        eventToSend.setSubtype(o.type);
        eventToSend.setValue(o.fp);
        eventToSend.setSignalTitle(message);
        eventToSend.setSignalError(error);
        eventToSend.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Boolean> flushEventQ() {
        Queue<PzEvent> flushedQ;
        Queue<PzEvent> queue = this.eventQ;
        synchronized (queue) {
            flushedQ = this.eventQ;
            this.eventQ = new ConcurrentLinkedQueue<PzEvent>();
            Future<?> remove = this.debounceRefs.remove(flushedQ);
            if (remove != null && !remove.isCancelled() && !remove.isDone()) {
                remove.cancel(false);
            }
        }
        if (flushedQ.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            mapper.writeValue((OutputStream)baos, flushedQ);
        }
        catch (IOException e) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        HttpClient client = HttpClient.newHttpClient();
        client.sendAsync(HttpRequest.newBuilder(URI.create(this.endpoint)).POST(HttpRequest.BodyPublishers.ofByteArray(baos.toByteArray())).header("Authorization", String.format("Bearer %s", this.apiToken)).header("X-PlayerZeroSdk", SDK_VERSION).header("X-PlayerZeroScope", String.format("%s %s", this.prod, this.dataset)).build(), HttpResponse.BodyHandlers.ofString()).whenComplete((resp, error) -> {
            if (this.dequeuedEvents != null) {
                this.dequeuedEvents.accept(flushedQ);
            }
            future.complete(true);
        });
        return future;
    }

    private PzPendingEvent newEvent(PzEventType type, Map<String, Object> metadata) {
        return this.pendingEvent(type).setMetadata(metadata);
    }

    private String privatizeText(String text) {
        if (text.length() > 0x100000) {
            return "";
        }
        String cleansedText = text;
        if (this.privacy != null) {
            cleansedText = this.privacy.apply(text);
        }
        return cleansedText.replaceAll(CHECKS.pattern(), "<redact>");
    }

    private void publishEvents(PzEvent data) {
        Queue<PzEvent> qRef = this.eventQ;
        this.eventQ.add(data);
        if (this.queuedEvent != null) {
            this.queuedEvent.accept(data);
        }
        if (this.eventQ.size() >= this.batchEventsSize) {
            this.flushEventQ();
            return;
        }
        Future previous = this.debounceRefs.put(qRef, scheduler.schedule(this::flushEventQ, (long)this.debounceInMs.intValue(), TimeUnit.MILLISECONDS));
        if (previous != null) {
            previous.cancel(false);
        }
    }
}

