/*
 * Decompiled with CFR 0.152.
 */
package app.playerzero.sdk;

import app.playerzero.sdk.PzEvent;
import app.playerzero.sdk.PzEventType;
import app.playerzero.sdk.PzIdentity;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PzPendingEvent {
    private final PzEventType type;
    private final Consumer<PzEvent> sendFn;
    private final Function<String, String> privatizeText;
    private final Supplier<String> eventIdGenerator;
    private final Map<String, Object> properties;
    private String id;
    private String subtype;
    private PzIdentity identity;
    private String value;
    private Date ts;
    private Map<String, Object> metadata;
    private String signalTitle;
    private Throwable signalError;

    PzPendingEvent(PzEventType type, PzIdentity defaultIdentity, Map<String, Object> eventProperties, Consumer<PzEvent> sendFn, Function<String, String> privatizeText, Supplier<String> eventIdGenerator) {
        assert (type != null) : "PzEventType is not defined";
        assert (sendFn != null) : "Send Implementation is not defined";
        this.type = type;
        this.identity = defaultIdentity;
        this.properties = eventProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(eventProperties);
        this.sendFn = sendFn;
        this.privatizeText = privatizeText;
        this.eventIdGenerator = eventIdGenerator;
    }

    public void send() {
        if (this.identity != null) {
            this.properties.put("identity", this.identity.properties);
        }
        if (this.metadata != null) {
            this.properties.put("metadata", this.metadata);
        }
        this.properties.put("thread", Thread.currentThread().getName());
        if (this.type == PzEventType.Signal) {
            this.properties.put("title", this.privatizeText.apply(this.signalTitle));
            if (this.signalError != null) {
                LinkedHashMap<String, String> stacktrace = new LinkedHashMap<String, String>();
                stacktrace.put("name", this.signalError.getClass().getName());
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                this.signalError.printStackTrace(pw);
                stacktrace.put("stack", sw.toString());
                this.properties.put("error", stacktrace);
            }
        }
        this.sendFn.accept(new PzEvent(this.id == null ? (this.eventIdGenerator != null ? this.eventIdGenerator.get() : null) : this.id, this.type, this.subtype, this.identity != null ? this.identity.actors : null, this.value, this.ts, this.properties));
    }

    public PzPendingEvent setSignalTitle(String title) {
        if (this.type != PzEventType.Signal) {
            throw new UnsupportedOperationException("Must be of Signal type");
        }
        this.signalTitle = title;
        return this;
    }

    public PzPendingEvent setSignalError(Throwable error) {
        if (this.type != PzEventType.Signal) {
            throw new UnsupportedOperationException("Must be of Signal type");
        }
        this.signalError = error;
        return this;
    }

    public PzPendingEvent setId(String id) {
        this.id = id;
        return this;
    }

    public PzPendingEvent setSubtype(String subtype) {
        this.subtype = subtype;
        return this;
    }

    public PzPendingEvent identify(String id) {
        return this.identify(id, null);
    }

    public PzPendingEvent identify(String userId, Map<String, Object> metadata) {
        HashMap<String, String> ids = null;
        if (userId != null) {
            ids = new HashMap<String, String>();
            ids.put("UserId", userId);
        }
        return this.identify(ids, metadata);
    }

    public PzPendingEvent identify(Map<String, String> actors) {
        return this.identify(actors, null);
    }

    public PzPendingEvent identify(Map<String, String> actors, Map<String, Object> metadata) {
        this.identity = actors == null ? null : new PzIdentity(actors, metadata);
        return this;
    }

    public PzPendingEvent setValue(String value) {
        this.value = this.type == PzEventType.Signal ? value : this.privatizeText.apply(value);
        return this;
    }

    public PzPendingEvent setTs(Date ts) {
        this.ts = ts;
        return this;
    }

    public PzPendingEvent setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }
}

