/*
 * Decompiled with CFR 0.152.
 */
package app.playerzero.sdk.logback;

import app.playerzero.sdk.PzApi;
import app.playerzero.sdk.PzEventType;
import app.playerzero.sdk.PzOptions;
import app.playerzero.sdk.PzPendingEvent;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.event.KeyValuePair;

public class PzSdkAppender
extends AppenderBase<ILoggingEvent> {
    private PzApi sdk;
    private String apiToken;
    private String dataset = "dataset";
    private Boolean prod = true;
    private Integer batchEventsSize = 100;
    private Integer debounceInMs = 2000;
    private Function<String, String> privacy;
    private String endpoint = "https://sdk.playerzero.app";
    private Map<String, Object> eventProperties;

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public String getDataset() {
        return this.dataset;
    }

    public void setDataset(String dataset) {
        this.dataset = dataset;
    }

    public Boolean getProd() {
        return this.prod;
    }

    public void setProd(Boolean prod) {
        this.prod = prod;
    }

    public Integer getBatchEventsSize() {
        return this.batchEventsSize;
    }

    public void setBatchEventsSize(Integer batchEventsSize) {
        this.batchEventsSize = batchEventsSize;
    }

    public Integer getDebounceInMs() {
        return this.debounceInMs;
    }

    public void setDebounceInMs(Integer debounceInMs) {
        this.debounceInMs = debounceInMs;
    }

    public Function<String, String> getPrivacy() {
        return this.privacy;
    }

    public void setPrivacy(Function<String, String> privacy) {
        this.privacy = privacy;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    public void setEventProperties(Map<String, Object> eventProperties) {
        this.eventProperties = eventProperties;
    }

    protected void append(ILoggingEvent eventObject) {
        String levelStr = eventObject.getLevel().levelStr;
        LinkedHashMap<String, Object> metadata = new LinkedHashMap<String, Object>();
        List pairs = eventObject.getKeyValuePairs();
        if (pairs != null) {
            for (KeyValuePair pair : pairs) {
                metadata.put(pair.key, pair.value);
            }
        }
        if ("ERROR".equals(levelStr)) {
            PzPendingEvent pzPendingEvent = this.sdk.pendingEvent(PzEventType.Signal).setSubtype(levelStr).setSignalTitle(eventObject.getMessage()).setMetadata(metadata).setTs(new Date(eventObject.getTimeStamp()));
            IThrowableProxy throwableProxy = eventObject.getThrowableProxy();
            if (throwableProxy instanceof ThrowableProxy) {
                pzPendingEvent.setSignalError(((ThrowableProxy)throwableProxy).getThrowable());
            }
            pzPendingEvent.send();
        } else if (!"OFF".equals(levelStr)) {
            this.sdk.pendingEvent(PzEventType.Logged).setSubtype(levelStr).setValue(eventObject.getMessage()).setMetadata(metadata).setTs(new Date(eventObject.getTimeStamp())).send();
        }
    }

    public void start() {
        this.sdk = PzApi.getInstance(this.apiToken, new PzOptions().setDataset(this.dataset).setProd(this.prod).setBatchEventsSize(this.batchEventsSize).setEndpoint(this.endpoint).setPrivacy(this.privacy).setDebounceInMs(this.debounceInMs).setEventProperties(this.eventProperties));
        super.start();
    }
}

