/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder;

import app.redwarp.gif.decoder.InvalidGifException;
import app.redwarp.gif.decoder.Parser$WhenMappings;
import app.redwarp.gif.decoder.PixelPacking;
import app.redwarp.gif.decoder.descriptors.Dimension;
import app.redwarp.gif.decoder.descriptors.GifDescriptor;
import app.redwarp.gif.decoder.descriptors.GraphicControlExtension;
import app.redwarp.gif.decoder.descriptors.Header;
import app.redwarp.gif.decoder.descriptors.ImageDescriptor;
import app.redwarp.gif.decoder.descriptors.LogicalScreenDescriptor;
import app.redwarp.gif.decoder.descriptors.Point;
import app.redwarp.gif.decoder.utils.InputStreamXKt;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\bJ,\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\nH\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\nH\u0002J\u001e\u0010\u001a\u001a\u00020\u000f*\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\nH\u0002J\f\u0010\u001e\u001a\u00020\r*\u00020\nH\u0002J\u0011\u0010\u001f\u001a\u00020 *\u00020\nH\u0000\u00a2\u0006\u0002\b!J\f\u0010\"\u001a\u00020#*\u00020\nH\u0002\u00a8\u0006$"}, d2={"Lapp/redwarp/gif/decoder/Parser;", "", "()V", "parse", "Lapp/redwarp/gif/decoder/descriptors/GifDescriptor;", "file", "Ljava/io/File;", "pixelPacking", "Lapp/redwarp/gif/decoder/PixelPacking;", "inputStream", "Ljava/io/InputStream;", "parseLoop", "Lkotlin/Pair;", "", "", "Lapp/redwarp/gif/decoder/descriptors/ImageDescriptor;", "bufferedSource", "parseApplicationId", "", "parseColorTable", "", "colorCount", "parseGraphicControl", "Lapp/redwarp/gif/decoder/descriptors/GraphicControlExtension;", "parseHeader", "Lapp/redwarp/gif/decoder/descriptors/Header;", "parseImageDescriptor", "graphicControlExtension", "parseLogicalScreenDescriptor", "Lapp/redwarp/gif/decoder/descriptors/LogicalScreenDescriptor;", "parseLoopCount", "readImageData", "", "readImageData$decoder", "skipSubBlocks", "", "decoder"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE;

    @NotNull
    public final GifDescriptor parse(@NotNull File file, @NotNull PixelPacking pixelPacking) throws InvalidGifException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        File file2 = file;
        boolean bl = false;
        return this.parse(new FileInputStream(file2), pixelPacking);
    }

    public static /* synthetic */ GifDescriptor parse$default(Parser parser, File file, PixelPacking pixelPacking, int n, Object object) throws InvalidGifException {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse(file, pixelPacking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final GifDescriptor parse(@NotNull InputStream inputStream, @NotNull PixelPacking pixelPacking) throws InvalidGifException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        Closeable closeable = inputStream;
        int n = 2048;
        boolean bl = false;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        n = 0;
        bl = false;
        Throwable throwable = null;
        try {
            void loopCount;
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl2 = false;
            Header header = INSTANCE.parseHeader(stream);
            LogicalScreenDescriptor logicalScreenDescriptor = INSTANCE.parseLogicalScreenDescriptor(stream);
            int[] globalColorTable = logicalScreenDescriptor.getHasGlobalColorTable() ? INSTANCE.parseColorTable(stream, logicalScreenDescriptor.getColorCount(), pixelPacking) : null;
            Pair<Integer, List<ImageDescriptor>> pair = INSTANCE.parseLoop(stream, pixelPacking);
            Integer n2 = (Integer)pair.component1();
            List imageDescriptors = (List)pair.component2();
            GifDescriptor gifDescriptor = new GifDescriptor(header, logicalScreenDescriptor, globalColorTable, (Integer)(imageDescriptors.size() <= 1 ? null : loopCount), imageDescriptors);
            return gifDescriptor;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ GifDescriptor parse$default(Parser parser, InputStream inputStream, PixelPacking pixelPacking, int n, Object object) throws InvalidGifException {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse(inputStream, pixelPacking);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Header parseHeader(InputStream $this$parseHeader) throws InvalidGifException {
        Header header;
        void headerString;
        String string;
        String string2 = string = InputStreamXKt.readAsciiString($this$parseHeader, 6);
        switch (string2.hashCode()) {
            case 2102227804: {
                if (!string2.equals("GIF89a")) throw (Throwable)new InvalidGifException((String)headerString + " is not a valid GIF header");
                break;
            }
            case 2102227742: {
                if (!string2.equals("GIF87a")) throw (Throwable)new InvalidGifException((String)headerString + " is not a valid GIF header");
                header = Header.GIF87a;
                return header;
            }
        }
        header = Header.GIF89a;
        return header;
        throw (Throwable)new InvalidGifException((String)headerString + " is not a valid GIF header");
    }

    private final LogicalScreenDescriptor parseLogicalScreenDescriptor(InputStream $this$parseLogicalScreenDescriptor) {
        int sizeOfGlobalColorTableMask;
        int hasGlobalColorTableMask;
        Dimension dimension = new Dimension(InputStreamXKt.readShortLe($this$parseLogicalScreenDescriptor), InputStreamXKt.readShortLe($this$parseLogicalScreenDescriptor));
        byte by = InputStreamXKt.readByte($this$parseLogicalScreenDescriptor);
        boolean bl = false;
        byte packedFields = UByte.constructor-impl((byte)by);
        int n = hasGlobalColorTableMask = -128;
        boolean bl2 = false;
        int n2 = n;
        byte by2 = packedFields;
        int n3 = 0;
        boolean hasGlobalColorTable = UByte.constructor-impl((byte)((byte)(n2 & by2))) == hasGlobalColorTableMask;
        n2 = sizeOfGlobalColorTableMask = 7;
        by2 = 0;
        n3 = n2;
        byte by3 = packedFields;
        boolean bl3 = false;
        n2 = UByte.constructor-impl((byte)((byte)(n3 & by3)));
        by2 = 0;
        int sizeOfGlobalColorTable = n2 & 0xFF;
        byte backgroundColorIndex = InputStreamXKt.readByte($this$parseLogicalScreenDescriptor);
        return new LogicalScreenDescriptor(dimension, hasGlobalColorTable, sizeOfGlobalColorTable, hasGlobalColorTable ? Byte.valueOf(backgroundColorIndex) : null, InputStreamXKt.readByte($this$parseLogicalScreenDescriptor));
    }

    /*
     * WARNING - void declaration
     */
    private final int[] parseColorTable(InputStream $this$parseColorTable, int colorCount, PixelPacking pixelPacking) {
        int[] colors = new int[colorCount];
        int n = 0;
        int n2 = colorCount;
        while (n < n2) {
            void colorIndex;
            int color;
            int n3;
            byte r = InputStreamXKt.readByte($this$parseColorTable);
            byte g = InputStreamXKt.readByte($this$parseColorTable);
            byte b = InputStreamXKt.readByte($this$parseColorTable);
            switch (Parser$WhenMappings.$EnumSwitchMapping$0[pixelPacking.ordinal()]) {
                case 1: {
                    n3 = (int)0xFF000000L | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                    break;
                }
                case 2: {
                    n3 = (int)0xFF000000L | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            colors[colorIndex] = color = n3;
            ++colorIndex;
        }
        return colors;
    }

    private final GraphicControlExtension parseGraphicControl(InputStream $this$parseGraphicControl) {
        byte blockSize = InputStreamXKt.readByte($this$parseGraphicControl);
        if (blockSize != (byte)4) {
            throw (Throwable)new InvalidGifException("Block size of the graphic control should be 4");
        }
        byte packedField = InputStreamXKt.readByte($this$parseGraphicControl);
        int disposalMethodValue = packedField >> 2 & 7;
        boolean hasTransparency = (packedField & 1) == 1;
        short s = InputStreamXKt.readShortLe($this$parseGraphicControl);
        boolean bl = false;
        short delayTime = UShort.constructor-impl((short)s);
        byte transparentColorIndex = InputStreamXKt.readByte($this$parseGraphicControl);
        byte terminator = InputStreamXKt.readByte($this$parseGraphicControl);
        if (terminator != (byte)0) {
            throw (Throwable)new InvalidGifException("Terminator not properly set");
        }
        GraphicControlExtension.Disposal disposalMethod = disposalMethodValue >= GraphicControlExtension.Disposal.values().length ? GraphicControlExtension.Disposal.NOT_SPECIFIED : GraphicControlExtension.Disposal.values()[disposalMethodValue];
        return new GraphicControlExtension(disposalMethod, delayTime, hasTransparency ? Byte.valueOf(transparentColorIndex) : null, null);
    }

    private final String parseApplicationId(InputStream $this$parseApplicationId) {
        $this$parseApplicationId.skip(1L);
        return InputStreamXKt.readAsciiString($this$parseApplicationId, 11);
    }

    private final int parseLoopCount(InputStream $this$parseLoopCount) {
        $this$parseLoopCount.skip(2L);
        short count = InputStreamXKt.readShortLe($this$parseLoopCount);
        $this$parseLoopCount.skip(1L);
        return count;
    }

    private final void skipSubBlocks(InputStream $this$skipSubBlocks) {
        long subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        while (subBlockSize != 0L) {
            $this$skipSubBlocks.skip(subBlockSize);
            subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Pair<Integer, List<ImageDescriptor>> parseLoop(InputStream bufferedSource, PixelPacking pixelPacking) {
        Integer loopCount = 0;
        GraphicControlExtension pendingGraphicControl = null;
        boolean bl = false;
        List imageDescriptors = new ArrayList();
        while (true) {
            block0 : switch (InputStreamXKt.readByte(bufferedSource)) {
                case 44: {
                    imageDescriptors.add(this.parseImageDescriptor(bufferedSource, pendingGraphicControl, pixelPacking));
                    pendingGraphicControl = null;
                    break;
                }
                case 59: {
                    return new Pair((Object)loopCount, (Object)imageDescriptors);
                }
                case 33: {
                    switch (InputStreamXKt.readByte(bufferedSource)) {
                        case -1: {
                            String applicationId = this.parseApplicationId(bufferedSource);
                            if (Intrinsics.areEqual((Object)applicationId, (Object)"NETSCAPE2.0") || Intrinsics.areEqual((Object)applicationId, (Object)"ANIMEXTS1.0")) {
                                loopCount = this.parseLoopCount(bufferedSource);
                                break block0;
                            }
                            this.skipSubBlocks(bufferedSource);
                            break block0;
                        }
                        case -7: {
                            pendingGraphicControl = this.parseGraphicControl(bufferedSource);
                            break block0;
                        }
                    }
                    this.skipSubBlocks(bufferedSource);
                    break;
                }
            }
        }
    }

    private final ImageDescriptor parseImageDescriptor(InputStream $this$parseImageDescriptor, GraphicControlExtension graphicControlExtension, PixelPacking pixelPacking) {
        int sizeOfLocalTableMask;
        Point position = new Point(InputStreamXKt.readShortLe($this$parseImageDescriptor), InputStreamXKt.readShortLe($this$parseImageDescriptor));
        Dimension dimension = new Dimension(InputStreamXKt.readShortLe($this$parseImageDescriptor), InputStreamXKt.readShortLe($this$parseImageDescriptor));
        byte by = InputStreamXKt.readByte($this$parseImageDescriptor);
        boolean bl = false;
        int packedFields = UByte.constructor-impl((byte)by);
        byte colorTableFlagMask = -128;
        int n = packedFields;
        boolean bl2 = false;
        int n2 = n;
        byte by2 = colorTableFlagMask;
        int n3 = 0;
        boolean usesLocalColorTable = UByte.constructor-impl((byte)((byte)(n2 & by2))) == colorTableFlagMask;
        byte interlacedMask = 64;
        n2 = packedFields;
        by2 = 0;
        n3 = n2;
        byte by3 = interlacedMask;
        int n4 = 0;
        boolean isInterlaced = UByte.constructor-impl((byte)((byte)(n3 & by3))) == interlacedMask;
        n3 = sizeOfLocalTableMask = 7;
        by3 = 0;
        n4 = n3;
        int n5 = packedFields;
        boolean bl3 = false;
        n3 = UByte.constructor-impl((byte)((byte)(n4 & n5)));
        by3 = 0;
        int sizeOfLocalTable = n3 & 0xFF;
        int colorCount = 1 << sizeOfLocalTable + 1;
        int[] localColorTable = usesLocalColorTable ? this.parseColorTable($this$parseImageDescriptor, colorCount, pixelPacking) : null;
        byte[] imageData = this.readImageData$decoder($this$parseImageDescriptor);
        return new ImageDescriptor(position, dimension, isInterlaced, localColorTable, imageData, graphicControlExtension);
    }

    @NotNull
    public final byte[] readImageData$decoder(@NotNull InputStream $this$readImageData) {
        Intrinsics.checkNotNullParameter((Object)$this$readImageData, (String)"$this$readImageData");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(InputStreamXKt.readByte($this$readImageData));
        block0: while (true) {
            byte by = InputStreamXKt.readByte($this$readImageData);
            int n = 0;
            by = UByte.constructor-impl((byte)by);
            n = 0;
            int blockSize = by & 0xFF;
            byteArrayOutputStream.write(blockSize);
            if (blockSize == 0) break;
            by = 0;
            n = 0;
            n = 0;
            int n2 = blockSize;
            while (true) {
                if (n >= n2) continue block0;
                int it = n++;
                boolean bl = false;
                byteArrayOutputStream.write($this$readImageData.read());
            }
            break;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private Parser() {
    }

    static {
        Parser parser;
        INSTANCE = parser = new Parser();
    }
}

