/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder.streams;

import app.redwarp.gif.decoder.streams.ReplayInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lapp/redwarp/gif/decoder/streams/BufferedReplayInputStream;", "Lapp/redwarp/gif/decoder/streams/ReplayInputStream;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "byteBuf", "Lio/netty/buffer/ByteBuf;", "Ljava/io/BufferedInputStream;", "replay", "", "close", "", "getPosition", "", "read", "byteArray", "", "offset", "length", "seek", "position", "decoder"})
public final class BufferedReplayInputStream
extends ReplayInputStream {
    private final BufferedInputStream inputStream;
    private final ByteBuf byteBuf;
    private boolean replay;

    @Override
    public void seek(int position) {
        this.byteBuf.readerIndex(position);
        this.replay = true;
        this.inputStream.close();
    }

    @Override
    public int getPosition() {
        return this.byteBuf.readerIndex();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() {
        int n;
        if (!this.replay) {
            void var1_1;
            int read = this.inputStream.read();
            this.byteBuf.writeByte(read);
            this.byteBuf.readerIndex(this.byteBuf.readerIndex() + 1);
            n = var1_1;
        } else {
            n = this.byteBuf.readByte() & 0xFF;
        }
        return n;
    }

    @Override
    public int read(@NotNull byte[] byteArray, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        if (!this.replay) {
            int readCount = this.inputStream.read(byteArray, offset, length);
            if (readCount > 0) {
                this.byteBuf.writeBytes(byteArray, offset, readCount);
            }
            this.byteBuf.readerIndex(this.byteBuf.readerIndex() + readCount);
            return readCount;
        }
        int readCount = length > this.byteBuf.readableBytes() ? this.byteBuf.readableBytes() : length;
        this.byteBuf.readBytes(byteArray, offset, readCount);
        return readCount;
    }

    @Override
    public int read(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        if (!this.replay) {
            int readCount = this.inputStream.read(byteArray);
            if (readCount > 0) {
                this.byteBuf.writeBytes(byteArray);
            }
            this.byteBuf.readerIndex(this.byteBuf.readerIndex() + readCount);
            return readCount;
        }
        int readCount = byteArray.length > this.byteBuf.readableBytes() ? this.byteBuf.readableBytes() : byteArray.length;
        this.byteBuf.readBytes(byteArray);
        return readCount;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    public BufferedReplayInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        boolean bl = false;
        this.inputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        ByteBuf byteBuf = Unpooled.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"Unpooled.buffer()");
        this.byteBuf = byteBuf;
    }
}

