/*
 * Decompiled with CFR 0.152.
 */
package app.redwarp.gif.decoder;

import app.redwarp.gif.decoder.InvalidGifException;
import app.redwarp.gif.decoder.PixelPacking;
import app.redwarp.gif.decoder.Result;
import app.redwarp.gif.decoder.descriptors.Dimension;
import app.redwarp.gif.decoder.descriptors.GifDescriptor;
import app.redwarp.gif.decoder.descriptors.GraphicControlExtension;
import app.redwarp.gif.decoder.descriptors.Header;
import app.redwarp.gif.decoder.descriptors.ImageData;
import app.redwarp.gif.decoder.descriptors.ImageDescriptor;
import app.redwarp.gif.decoder.descriptors.LogicalScreenDescriptor;
import app.redwarp.gif.decoder.descriptors.Point;
import app.redwarp.gif.decoder.streams.BufferedReplayInputStream;
import app.redwarp.gif.decoder.streams.RandomAccessFileInputStream;
import app.redwarp.gif.decoder.streams.ReplayInputStream;
import app.redwarp.gif.decoder.utils.InputStreamXKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tJ\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\b\u001a\u00020\tJ\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\f2\b\b\u0002\u0010\b\u001a\u00020\tJ,\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000e2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\fH\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\fH\u0002J\u001e\u0010\u001c\u001a\u00020\u0011*\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\fH\u0002J\f\u0010 \u001a\u00020\u000f*\u00020\fH\u0002J\n\u0010!\u001a\u00020\"*\u00020\u0007J\f\u0010#\u001a\u00020$*\u00020\fH\u0002\u00a8\u0006%"}, d2={"Lapp/redwarp/gif/decoder/Parser;", "", "()V", "parse", "Lapp/redwarp/gif/decoder/Result;", "Lapp/redwarp/gif/decoder/descriptors/GifDescriptor;", "inputStream", "Lapp/redwarp/gif/decoder/streams/ReplayInputStream;", "pixelPacking", "Lapp/redwarp/gif/decoder/PixelPacking;", "file", "Ljava/io/File;", "Ljava/io/InputStream;", "parseLoop", "Lkotlin/Pair;", "", "", "Lapp/redwarp/gif/decoder/descriptors/ImageDescriptor;", "bufferedSource", "parseApplicationId", "", "parseColorTable", "", "colorCount", "parseGraphicControl", "Lapp/redwarp/gif/decoder/descriptors/GraphicControlExtension;", "parseHeader", "Lapp/redwarp/gif/decoder/descriptors/Header;", "parseImageDescriptor", "graphicControlExtension", "parseLogicalScreenDescriptor", "Lapp/redwarp/gif/decoder/descriptors/LogicalScreenDescriptor;", "parseLoopCount", "readImageData", "Lapp/redwarp/gif/decoder/descriptors/ImageData;", "skipSubBlocks", "", "decoder"})
public final class Parser {
    @NotNull
    public static final Parser INSTANCE = new Parser();

    private Parser() {
    }

    @NotNull
    public final Result<GifDescriptor> parse(@NotNull File file, @NotNull PixelPacking pixelPacking) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        return this.parse(new RandomAccessFileInputStream(file), pixelPacking);
    }

    public static /* synthetic */ Result parse$default(Parser parser, File file, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse(file, pixelPacking);
    }

    @NotNull
    public final Result<GifDescriptor> parse(@NotNull InputStream inputStream, @NotNull PixelPacking pixelPacking) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        return this.parse(new BufferedReplayInputStream(inputStream), pixelPacking);
    }

    public static /* synthetic */ Result parse$default(Parser parser, InputStream inputStream, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse(inputStream, pixelPacking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Result<GifDescriptor> parse(@NotNull ReplayInputStream inputStream, @NotNull PixelPacking pixelPacking) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)((Object)pixelPacking), (String)"pixelPacking");
        try {
            Result.Success<GifDescriptor> success;
            object = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ReplayInputStream stream = (ReplayInputStream)object;
                boolean bl3 = false;
                Header header = INSTANCE.parseHeader(stream);
                LogicalScreenDescriptor logicalScreenDescriptor = INSTANCE.parseLogicalScreenDescriptor(stream);
                int[] globalColorTable = logicalScreenDescriptor.getHasGlobalColorTable() ? INSTANCE.parseColorTable(stream, logicalScreenDescriptor.getColorCount(), pixelPacking) : (int[])null;
                Pair<Integer, List<ImageDescriptor>> pair = INSTANCE.parseLoop(stream, pixelPacking);
                Integer loopCount = (Integer)pair.component1();
                List imageDescriptors = (List)pair.component2();
                success = new Result.Success<GifDescriptor>(new GifDescriptor(header, logicalScreenDescriptor, globalColorTable, imageDescriptors.size() <= 1 ? null : loopCount, imageDescriptors, stream));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = success;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exception.localizedMessage");
            object = new Result.Error(string);
        }
        return object;
    }

    public static /* synthetic */ Result parse$default(Parser parser, ReplayInputStream replayInputStream, PixelPacking pixelPacking, int n, Object object) {
        if ((n & 2) != 0) {
            pixelPacking = PixelPacking.ARGB;
        }
        return parser.parse(replayInputStream, pixelPacking);
    }

    private final Header parseHeader(InputStream $this$parseHeader) throws InvalidGifException {
        Header header;
        String headerString = InputStreamXKt.readAsciiString($this$parseHeader, 6);
        if (Intrinsics.areEqual((Object)headerString, (Object)"GIF87a")) {
            header = Header.GIF87a;
        } else if (Intrinsics.areEqual((Object)headerString, (Object)"GIF89a")) {
            header = Header.GIF89a;
        } else {
            throw new InvalidGifException(Intrinsics.stringPlus((String)headerString, (Object)" is not a valid GIF header"));
        }
        return header;
    }

    private final LogicalScreenDescriptor parseLogicalScreenDescriptor(InputStream $this$parseLogicalScreenDescriptor) {
        Dimension dimension = new Dimension(InputStreamXKt.readShortLe($this$parseLogicalScreenDescriptor), InputStreamXKt.readShortLe($this$parseLogicalScreenDescriptor));
        byte by = InputStreamXKt.readByte($this$parseLogicalScreenDescriptor);
        boolean bl = false;
        byte packedFields = UByte.constructor-impl((byte)by);
        byte hasGlobalColorTableMask = -128;
        boolean bl2 = false;
        byte by2 = hasGlobalColorTableMask;
        byte by3 = packedFields;
        int n = 0;
        boolean hasGlobalColorTable = UByte.constructor-impl((byte)((byte)(by2 & by3))) == hasGlobalColorTableMask;
        int sizeOfGlobalColorTableMask = 7;
        by3 = 0;
        n = sizeOfGlobalColorTableMask;
        byte by4 = packedFields;
        boolean bl3 = false;
        by3 = UByte.constructor-impl((byte)((byte)(n & by4)));
        n = 0;
        int sizeOfGlobalColorTable = by3 & 0xFF;
        byte backgroundColorIndex = InputStreamXKt.readByte($this$parseLogicalScreenDescriptor);
        return new LogicalScreenDescriptor(dimension, hasGlobalColorTable, sizeOfGlobalColorTable, hasGlobalColorTable ? Byte.valueOf(backgroundColorIndex) : null, InputStreamXKt.readByte($this$parseLogicalScreenDescriptor));
    }

    private final int[] parseColorTable(InputStream $this$parseColorTable, int colorCount, PixelPacking pixelPacking) {
        int[] colors = new int[colorCount];
        int n = 0;
        if (n < colorCount) {
            do {
                int color;
                int n2;
                int colorIndex = n++;
                byte r = InputStreamXKt.readByte($this$parseColorTable);
                byte g = InputStreamXKt.readByte($this$parseColorTable);
                byte b = InputStreamXKt.readByte($this$parseColorTable);
                PixelPacking pixelPacking2 = pixelPacking;
                int n3 = WhenMappings.$EnumSwitchMapping$0[pixelPacking2.ordinal()];
                switch (n3) {
                    case 1: {
                        n2 = 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
                        break;
                    }
                    case 2: {
                        n2 = 0xFF000000 | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                colors[colorIndex] = color = n2;
            } while (n < colorCount);
        }
        return colors;
    }

    private final GraphicControlExtension parseGraphicControl(InputStream $this$parseGraphicControl) {
        byte blockSize = InputStreamXKt.readByte($this$parseGraphicControl);
        if (blockSize != 4) {
            throw new InvalidGifException("Block size of the graphic control should be 4");
        }
        byte packedField = InputStreamXKt.readByte($this$parseGraphicControl);
        int disposalMethodValue = packedField >> 2 & 7;
        boolean hasTransparency = (packedField & 1) == 1;
        short s = InputStreamXKt.readShortLe($this$parseGraphicControl);
        boolean bl = false;
        short delayTime = UShort.constructor-impl((short)s);
        byte transparentColorIndex = InputStreamXKt.readByte($this$parseGraphicControl);
        byte terminator = InputStreamXKt.readByte($this$parseGraphicControl);
        if (terminator != 0) {
            throw new InvalidGifException("Terminator not properly set");
        }
        GraphicControlExtension.Disposal disposalMethod = disposalMethodValue >= GraphicControlExtension.Disposal.values().length ? GraphicControlExtension.Disposal.NOT_SPECIFIED : GraphicControlExtension.Disposal.values()[disposalMethodValue];
        return new GraphicControlExtension(disposalMethod, delayTime, hasTransparency ? Byte.valueOf(transparentColorIndex) : null, null);
    }

    private final String parseApplicationId(InputStream $this$parseApplicationId) {
        $this$parseApplicationId.skip(1L);
        return InputStreamXKt.readAsciiString($this$parseApplicationId, 11);
    }

    private final int parseLoopCount(InputStream $this$parseLoopCount) {
        $this$parseLoopCount.skip(2L);
        short count = InputStreamXKt.readShortLe($this$parseLoopCount);
        $this$parseLoopCount.skip(1L);
        return count;
    }

    private final void skipSubBlocks(InputStream $this$skipSubBlocks) {
        long subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        while (subBlockSize != 0L) {
            $this$skipSubBlocks.skip(subBlockSize);
            subBlockSize = InputStreamXKt.readByte($this$skipSubBlocks);
        }
    }

    private final Pair<Integer, List<ImageDescriptor>> parseLoop(ReplayInputStream bufferedSource, PixelPacking pixelPacking) {
        Integer loopCount = 0;
        GraphicControlExtension pendingGraphicControl = null;
        byte by = 0;
        List imageDescriptors = new ArrayList();
        while (true) {
            if ((by = InputStreamXKt.readByte(bufferedSource)) == 44) {
                imageDescriptors.add(this.parseImageDescriptor(bufferedSource, pendingGraphicControl, pixelPacking));
                pendingGraphicControl = null;
                continue;
            }
            if (by == 59) break;
            if (by != 33) continue;
            byte by2 = InputStreamXKt.readByte(bufferedSource);
            if (by2 == -1) {
                String applicationId = this.parseApplicationId(bufferedSource);
                if (Intrinsics.areEqual((Object)applicationId, (Object)"NETSCAPE2.0") || Intrinsics.areEqual((Object)applicationId, (Object)"ANIMEXTS1.0")) {
                    loopCount = this.parseLoopCount(bufferedSource);
                    continue;
                }
                this.skipSubBlocks(bufferedSource);
                continue;
            }
            if (by2 == -7) {
                pendingGraphicControl = this.parseGraphicControl(bufferedSource);
                continue;
            }
            this.skipSubBlocks(bufferedSource);
        }
        return new Pair((Object)loopCount, (Object)imageDescriptors);
    }

    private final ImageDescriptor parseImageDescriptor(ReplayInputStream $this$parseImageDescriptor, GraphicControlExtension graphicControlExtension, PixelPacking pixelPacking) {
        Point position = new Point(InputStreamXKt.readShortLe($this$parseImageDescriptor), InputStreamXKt.readShortLe($this$parseImageDescriptor));
        Dimension dimension = new Dimension(InputStreamXKt.readShortLe($this$parseImageDescriptor), InputStreamXKt.readShortLe($this$parseImageDescriptor));
        byte by = InputStreamXKt.readByte($this$parseImageDescriptor);
        boolean bl = false;
        byte packedFields = UByte.constructor-impl((byte)by);
        byte colorTableFlagMask = -128;
        boolean bl2 = false;
        byte by2 = packedFields;
        byte by3 = colorTableFlagMask;
        byte by4 = 0;
        boolean usesLocalColorTable = UByte.constructor-impl((byte)((byte)(by2 & by3))) == colorTableFlagMask;
        byte interlacedMask = 64;
        by3 = 0;
        by4 = packedFields;
        byte by5 = interlacedMask;
        int n = 0;
        boolean isInterlaced = UByte.constructor-impl((byte)((byte)(by4 & by5))) == interlacedMask;
        int sizeOfLocalTableMask = 7;
        by5 = 0;
        n = sizeOfLocalTableMask;
        byte by6 = packedFields;
        boolean bl3 = false;
        by5 = UByte.constructor-impl((byte)((byte)(n & by6)));
        n = 0;
        int sizeOfLocalTable = by5 & 0xFF;
        int colorCount = 1 << sizeOfLocalTable + 1;
        int[] localColorTable = usesLocalColorTable ? this.parseColorTable($this$parseImageDescriptor, colorCount, pixelPacking) : (int[])null;
        ImageData imageData = this.readImageData($this$parseImageDescriptor);
        return new ImageDescriptor(position, dimension, isInterlaced, localColorTable, imageData, graphicControlExtension);
    }

    @NotNull
    public final ImageData readImageData(@NotNull ReplayInputStream $this$readImageData) {
        Intrinsics.checkNotNullParameter((Object)$this$readImageData, (String)"<this>");
        int position = $this$readImageData.getPosition();
        int length = 1;
        $this$readImageData.skip(1L);
        while (true) {
            int n = InputStreamXKt.readByte($this$readImageData);
            boolean bl = false;
            n = UByte.constructor-impl((byte)n);
            bl = false;
            int blockSize = n & 0xFF;
            n = length;
            length = n + 1;
            if (blockSize == 0) break;
            length += blockSize;
            $this$readImageData.skip(blockSize);
        }
        return new ImageData(position, length);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PixelPacking.values().length];
            nArray[PixelPacking.ARGB.ordinal()] = 1;
            nArray[PixelPacking.ABGR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

